/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.tasks;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.tasks.PostgreBackupAllSettings;
import org.jkiss.dbeaver.ext.postgresql.tasks.PostgreDatabaseBackupAllInfo;
import org.jkiss.dbeaver.ext.postgresql.tasks.PostgreNativeToolHandler;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.fs.DBFUtils;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.registry.task.TaskPreferenceStore;
import org.jkiss.utils.CommonUtils;

public class PostgreDatabaseBackupAllHandler
extends PostgreNativeToolHandler<PostgreBackupAllSettings, DBSObject, PostgreDatabaseBackupAllInfo> {
    @Override
    protected boolean isExportWizard() {
        return true;
    }

    public Collection<PostgreDatabaseBackupAllInfo> getRunInfo(PostgreBackupAllSettings settings) {
        return settings.getExportObjects();
    }

    protected PostgreBackupAllSettings createTaskSettings(DBRRunnableContext context, DBTTask task) throws DBException {
        PostgreBackupAllSettings settings = new PostgreBackupAllSettings();
        settings.loadSettings(context, (DBPPreferenceStore)new TaskPreferenceStore(task));
        return settings;
    }

    protected boolean validateTaskParameters(DBTTask task, PostgreBackupAllSettings settings, Log log) {
        if ("pgDatabaseBackupAll".equals(task.getType().getId())) {
            for (PostgreDatabaseBackupAllInfo exportObject : settings.getExportObjects()) {
                String dir = settings.getOutputFolder(exportObject);
                try {
                    Path outputFolderPath = DBFUtils.resolvePathFromString((DBRProgressMonitor)new VoidProgressMonitor(), (DBPProject)task.getProject(), (String)dir);
                    if (Files.exists(outputFolderPath, new LinkOption[0])) continue;
                    Files.createDirectories(outputFolderPath, new FileAttribute[0]);
                }
                catch (Exception e) {
                    log.error((Object)("Can't create directory '" + dir + "'"), (Throwable)e);
                    return false;
                }
            }
        }
        return true;
    }

    protected boolean needsModelRefresh() {
        return false;
    }

    @Override
    public boolean isVerbose() {
        return true;
    }

    protected boolean isLogInputStream() {
        return false;
    }

    @Override
    public void fillProcessParameters(PostgreBackupAllSettings settings, PostgreDatabaseBackupAllInfo arg, List<String> cmd) throws IOException {
        PostgreDataSource dataSource;
        List<PostgreDatabase> allDatabases;
        List<PostgreDatabase> includedDatabases;
        super.fillProcessParameters(settings, arg, cmd);
        if (!CommonUtils.isEmpty((String)settings.getEncoding())) {
            cmd.add("--encoding=" + settings.getEncoding());
        }
        if (settings.isExportOnlyMetadata()) {
            cmd.add("--schema-only");
        }
        if (settings.isExportOnlyGlobals()) {
            cmd.add("--globals-only");
        }
        if (settings.isExportOnlyRoles()) {
            cmd.add("--roles-only");
        }
        if (settings.isExportOnlyTablespaces()) {
            cmd.add("--tablespaces-only");
        }
        if (settings.isNoPrivileges()) {
            cmd.add("--no-privileges");
        }
        if (settings.isNoOwner()) {
            cmd.add("--no-owner");
        }
        if (!settings.isAddRolesPasswords()) {
            cmd.add("--no-role-passwords");
        }
        cmd.add("--file");
        cmd.add(settings.getOutputFile(arg));
        if (!settings.getExportObjects().isEmpty() && !CommonUtils.isEmpty(includedDatabases = arg.getDatabases()) && (allDatabases = (dataSource = arg.getDataSource()).getDatabases()).size() != includedDatabases.size()) {
            ArrayList<PostgreDatabase> allDatabasesCopy = new ArrayList<PostgreDatabase>(allDatabases);
            allDatabasesCopy.removeAll(includedDatabases);
            for (PostgreDatabase database : allDatabasesCopy) {
                cmd.add("--exclude-database=" + PostgreDatabaseBackupAllHandler.escapeCLIIdentifier(database.getName()));
            }
        }
    }

    protected List<String> getCommandLine(PostgreBackupAllSettings settings, PostgreDatabaseBackupAllInfo arg) throws IOException {
        ArrayList<String> cmd = new ArrayList<String>();
        this.fillProcessParameters(settings, arg, cmd);
        return cmd;
    }
}

