/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreForeignServer;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreInformation;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreScriptObject;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class PostgreUserMapping
extends PostgreInformation
implements PostgreScriptObject {
    private long oid;
    private PostgreForeignServer foreignServer;
    private String name;
    private String[] serverOptions;
    private String[] userMappingOptions;

    public PostgreUserMapping(PostgreForeignServer foreignServer, ResultSet dbResult) throws SQLException {
        super(foreignServer.getDatabase());
        this.foreignServer = foreignServer;
        this.loadInfo(dbResult);
    }

    private void loadInfo(ResultSet dbResult) throws SQLException {
        this.oid = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"oid");
        this.name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"rolname");
        this.serverOptions = PostgreUtils.safeGetStringArray(dbResult, "srvoptions");
        this.userMappingOptions = PostgreUtils.safeGetStringArray(dbResult, "umoptions");
    }

    public long getObjectId() {
        return this.oid;
    }

    @Property(viewable=true, order=3)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Property(viewable=true, order=4)
    public String[] getServerOptions() {
        return this.serverOptions;
    }

    @Property(viewable=true, order=5)
    public String[] getUserMappingOptions() {
        return this.userMappingOptions;
    }

    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        return "-- User Mapping: " + this.getName() + "\n\n" + "-- DROP USER MAPPING FOR " + this.getName() + " SERVER " + this.foreignServer.getName() + ";\n\n" + "CREATE USER MAPPING" + "\n\t" + "FOR " + this.getName() + "\n\t" + "SERVER " + this.foreignServer.getName() + "\n\t" + "OPTIONS " + PostgreUtils.getOptionsString(this.userMappingOptions);
    }

    @Override
    public void setObjectDefinitionText(String sourceText) throws DBException {
    }
}

