/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreRule;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableConstraint;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableConstraintBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableContainer;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTrigger;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreView;
import org.jkiss.dbeaver.model.DBPObjectStatistics;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.AbstractExecutionSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectLookupCache;
import org.jkiss.dbeaver.model.impl.struct.RelationalObjectType;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectType;
import org.jkiss.utils.ByteNumberFormat;
import org.jkiss.utils.CommonUtils;

public abstract class PostgreTableReal
extends PostgreTableBase
implements DBPObjectStatistics {
    private static final Log log = Log.getLog(PostgreTableReal.class);
    protected long rowCountEstimate;
    protected volatile transient Long rowCount;
    protected volatile transient Long diskSpace;
    protected volatile transient long tableRelSize;
    private final TriggerCache triggerCache = ((PostgreDataSource)this.getDataSource()).getServerType().supportsTriggers() ? new TriggerCache() : null;
    private final RuleCache ruleCache = ((PostgreDataSource)this.getDataSource()).getServerType().supportsRules() ? new RuleCache() : null;

    public boolean isRefreshSchemaStatisticsOnTableRefresh() {
        return true;
    }

    protected PostgreTableReal(PostgreTableContainer container) {
        super(container);
    }

    protected PostgreTableReal(PostgreTableContainer container, ResultSet dbResult) {
        super(container, dbResult);
        this.rowCountEstimate = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"reltuples");
    }

    public PostgreTableReal(DBRProgressMonitor monitor, PostgreTableContainer container, PostgreTableReal source, boolean persisted) throws DBException {
        super(monitor, container, source, persisted);
        for (PostgreTableConstraint srcConstr : CommonUtils.safeCollection(source.getConstraints(monitor))) {
            PostgreTableConstraint constr = new PostgreTableConstraint(monitor, this, srcConstr);
            this.getSchema().getConstraintCache().cacheObject(constr);
        }
    }

    @Nullable
    public TriggerCache getTriggerCache() {
        return this.triggerCache;
    }

    @Property(category="Statistics", viewable=true, order=22)
    public long getRowCountEstimate() {
        return this.rowCountEstimate;
    }

    @Property(category="Statistics", viewable=false, expensive=true, order=23)
    public Long getRowCount(DBRProgressMonitor monitor) {
        if (this.rowCount != null) {
            return this.rowCount;
        }
        if (!this.isPersisted()) {
            return null;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (DBCSession session = DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Read row count");){
                this.rowCount = this.countData((DBCExecutionSource)new AbstractExecutionSource((DBSDataContainer)this, session.getExecutionContext(), (Object)this), session, null, 0L);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (DBException e) {
            log.debug((Object)"Can't fetch row count", (Throwable)e);
        }
        if (this.rowCount == null) {
            this.rowCount = -1L;
        }
        return this.rowCount;
    }

    @Property(category="Statistics", viewable=false, order=24, formatter=ByteNumberFormat.class)
    public Long getDiskSpace(DBRProgressMonitor monitor) {
        this.readTableStats(monitor);
        return this.diskSpace;
    }

    @Property(category="Statistics", viewable=false, order=25, formatter=ByteNumberFormat.class)
    public long getRelationSize(DBRProgressMonitor monitor) {
        this.readTableStats(monitor);
        return this.tableRelSize;
    }

    public boolean hasStatistics() {
        return this.diskSpace != null;
    }

    public long getStatObjectSize() {
        return this.diskSpace == null ? 0L : this.diskSpace;
    }

    @Nullable
    public DBPPropertySource getStatProperties() {
        return null;
    }

    private void readTableStats(DBRProgressMonitor monitor) {
        if (this.diskSpace != null || !((PostgreDataSource)this.getDataSource()).getServerType().supportsTableStatistics()) {
            return;
        }
        if (!this.isPersisted() || this instanceof PostgreView || !((PostgreDataSource)this.getDataSource()).isServerVersionAtLeast(8, 1)) {
            return;
        }
        if (!((PostgreDataSource)this.getDataSource()).getServerType().supportsRelationSizeCalc()) {
            return;
        }
        try {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (DBCSession session = DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Calculate relation size on disk");){
                    this.readTableStatistics((JDBCSession)session);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                log.debug((Object)"Can't fetch disk space", (Throwable)e);
            }
        }
        finally {
            if (this.diskSpace == null) {
                this.diskSpace = -1L;
            }
        }
    }

    protected void readTableStatistics(JDBCSession session) throws DBException, SQLException {
        if (!((PostgreDataSource)this.getDataSource()).getServerType().supportsTableStatistics()) {
            return;
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try (JDBCPreparedStatement dbStat = session.prepareStatement("select pg_catalog.pg_total_relation_size(?) as total_rel_size,pg_catalog.pg_relation_size(?) as rel_size");){
            dbStat.setLong(1, this.getObjectId());
            dbStat.setLong(2, this.getObjectId());
            Throwable throwable2 = null;
            Object var6_9 = null;
            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                if (dbResult.next()) {
                    this.fetchStatistics(dbResult);
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    protected void fetchStatistics(JDBCResultSet dbResult) throws DBException, SQLException {
        this.diskSpace = dbResult.getLong("total_rel_size");
        this.tableRelSize = dbResult.getLong("rel_size");
    }

    @Override
    public Collection<PostgreTableConstraint> getConstraints(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.getSchema().getConstraintCache().getTypedObjects(monitor, this.getSchema(), this, PostgreTableConstraint.class);
    }

    @Override
    public PostgreTableConstraintBase getConstraint(@NotNull DBRProgressMonitor monitor, String ukName) throws DBException {
        return (PostgreTableConstraintBase)this.getSchema().getConstraintCache().getObject(monitor, this.getSchema(), this, ukName);
    }

    @Override
    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (this.diskSpace != null && this.isRefreshSchemaStatisticsOnTableRefresh()) {
            this.getSchema().resetStatistics();
            this.diskSpace = null;
        }
        this.rowCount = null;
        this.tableRelSize = 0L;
        return super.refreshObject(monitor);
    }

    @Nullable
    @Association
    public List<PostgreTrigger> getTriggers(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.triggerCache != null ? this.triggerCache.getAllObjects(monitor, this) : List.of();
    }

    @Nullable
    public PostgreTrigger getTrigger(DBRProgressMonitor monitor, String name) throws DBException {
        return this.triggerCache != null ? (PostgreTrigger)this.triggerCache.getObject(monitor, this, name) : null;
    }

    @Association
    public Collection<PostgreRule> getRules(DBRProgressMonitor monitor) throws DBException {
        return this.ruleCache != null ? this.ruleCache.getAllObjects(monitor, this) : Collections.emptyList();
    }

    @Override
    public void setObjectDefinitionText(String sourceText) throws DBException {
        throw new DBException("Table DDL is read-only");
    }

    public DBSObjectType getObjectType() {
        return RelationalObjectType.TYPE_TABLE;
    }

    class RuleCache
    extends JDBCObjectCache<PostgreTableReal, PostgreRule> {
        RuleCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull PostgreTableReal owner) throws SQLException {
            return session.prepareStatement("SELECT r.oid,r.*, pg_get_ruledef(r.oid) AS definition\nFROM pg_rewrite r\nWHERE r.ev_class=" + owner.getObjectId() + " AND r.rulename <> '_RETURN'::name");
        }

        protected PostgreRule fetchObject(@NotNull JDBCSession session, @NotNull PostgreTableReal owner, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            return new PostgreRule(session.getProgressMonitor(), owner, (ResultSet)dbResult);
        }
    }

    class TriggerCache
    extends JDBCObjectLookupCache<PostgreTableReal, PostgreTrigger> {
        TriggerCache() {
        }

        @NotNull
        public JDBCStatement prepareLookupStatement(@NotNull JDBCSession session, @NotNull PostgreTableReal owner, @Nullable PostgreTrigger object, @Nullable String objectName) throws SQLException {
            String statement = "SELECT x.oid,x.*,p.pronamespace as func_schema_id,d.description\nFROM pg_catalog.pg_trigger x\nLEFT OUTER JOIN pg_catalog.pg_proc p ON p.oid=x.tgfoid \nLEFT OUTER JOIN pg_catalog.pg_description d ON d.objoid=x.oid AND d.objsubid=0 \nWHERE x.tgrelid = ?" + (object != null || CommonUtils.isNotEmpty((String)objectName) ? "\nAND x.tgname = ?" : "") + (((PostgreDataSource)PostgreTableReal.this.getDataSource()).isServerVersionAtLeast(9, 0) ? " AND NOT x.tgisinternal" : "");
            JDBCPreparedStatement prepareStatement = session.prepareStatement(statement);
            prepareStatement.setLong(1, owner.getObjectId());
            if (object != null || CommonUtils.isNotEmpty((String)objectName)) {
                prepareStatement.setString(2, object != null ? object.getName() : objectName);
            }
            return prepareStatement;
        }

        protected PostgreTrigger fetchObject(@NotNull JDBCSession session, @NotNull PostgreTableReal owner, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            String name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"tgname");
            if (CommonUtils.isEmpty((String)name)) {
                return null;
            }
            return new PostgreTrigger(session.getProgressMonitor(), owner, name, (ResultSet)dbResult);
        }
    }
}

