/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors;

import java.lang.ref.WeakReference;
import java.util.ArrayDeque;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TabFolder;
import org.jkiss.code.NotNull;

public class EditorAccessibleAdapter
extends AccessibleControlAdapter
implements AccessibleListener {
    private static final String DATA_KEY = EditorAccessibleAdapter.class.getName();
    private final WeakReference<Composite> composite;
    private boolean active;

    private EditorAccessibleAdapter(@NotNull Composite composite) {
        this.composite = new WeakReference<Composite>(composite);
    }

    public static boolean isActive(@NotNull Composite composite) {
        Composite c = composite;
        while (c != null) {
            Object data = c.getData(DATA_KEY);
            if (data instanceof EditorAccessibleAdapter && ((EditorAccessibleAdapter)((Object)data)).active) {
                return true;
            }
            c = c.getParent();
        }
        return false;
    }

    public static void install(@NotNull Composite composite) {
        EditorAccessibleAdapter adapter = new EditorAccessibleAdapter(composite);
        Accessible accessible = composite.getAccessible();
        accessible.addAccessibleListener((AccessibleListener)adapter);
        accessible.addAccessibleControlListener((AccessibleControlListener)adapter);
        composite.setData(DATA_KEY, (Object)adapter);
    }

    public void getName(AccessibleEvent e) {
        Composite composite = (Composite)this.composite.get();
        if (composite != null) {
            e.result = EditorAccessibleAdapter.getWorkbenchLocation(composite);
            this.active = true;
        }
    }

    public void getValue(AccessibleControlEvent e) {
        Composite composite = (Composite)this.composite.get();
        if (composite != null) {
            e.result = EditorAccessibleAdapter.getWorkbenchLocation(composite);
            this.active = true;
        }
    }

    public void getHelp(AccessibleEvent e) {
    }

    public void getKeyboardShortcut(AccessibleEvent e) {
    }

    public void getDescription(AccessibleEvent e) {
    }

    @NotNull
    private static String getWorkbenchLocation(@NotNull Composite composite) {
        ArrayDeque<String> path = new ArrayDeque<String>();
        Composite c = composite;
        while (c != null) {
            int index;
            TabFolder folder;
            if (c instanceof TabFolder) {
                folder = (TabFolder)c;
                index = folder.getSelectionIndex();
                if (index >= 0) {
                    path.offerFirst(EditorAccessibleAdapter.getTabName(folder.getItem(index).getText(), index, folder.getItemCount()));
                }
            } else if (c instanceof CTabFolder && (index = (folder = (CTabFolder)c).getSelectionIndex()) >= 0) {
                path.offerFirst(EditorAccessibleAdapter.getTabName(folder.getItem(index).getText(), index, folder.getItemCount()));
            }
            c = c.getParent();
        }
        return String.join((CharSequence)", ", path);
    }

    @NotNull
    private static String getTabName(@NotNull String text, int index, int count) {
        return String.format("%s tab, %d out of %d", text, index + 1, count);
    }
}

