/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors;

import java.util.Objects;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.struct.DBSFolder;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.editors.DatabaseEditorInput;
import org.jkiss.dbeaver.ui.editors.DatabaseLazyEditorInput;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.ui.editors.ILazyEditorInput;
import org.jkiss.dbeaver.ui.editors.IUnloadableEditorInput;

public class DatabaseNodeEditorInput
extends DatabaseEditorInput<DBNDatabaseNode>
implements IUnloadableEditorInput {
    private final String nodePath;
    private final String nodeName;

    public DatabaseNodeEditorInput(@NotNull DBNDatabaseNode dbmNode) {
        this(dbmNode, (DBECommandContext)null);
    }

    public DatabaseNodeEditorInput(@NotNull DBNDatabaseNode dbnDatabaseNode, @Nullable DBECommandContext commandContext) {
        super(dbnDatabaseNode, commandContext);
        this.nodePath = dbnDatabaseNode.getNodeItemPath();
        this.nodeName = dbnDatabaseNode.getNodeName();
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == DBSObject.class) {
            DBSObject databaseObject = this.getDatabaseObject();
            return adapter.cast(databaseObject);
        }
        return super.getAdapter(adapter);
    }

    @Override
    public String getToolTipText() {
        StringBuilder toolTip = new StringBuilder();
        Object node = this.getNavigatorNode();
        while (node != null) {
            if (!(node instanceof DBSFolder)) {
                toolTip.append(node.getNodeType());
                toolTip.append(": ");
                toolTip.append(node.getNodeName());
                toolTip.append(" \n");
                if (node instanceof DBNDataSource) break;
            }
            node = node.getParentNode();
        }
        EditorUtils.appendProjectToolTip(toolTip, this.getNavigatorNode().getOwnerProject());
        return toolTip.toString();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof DatabaseNodeEditorInput && super.equals(obj);
    }

    @Override
    @NotNull
    public ILazyEditorInput unloadInput() {
        DBCExecutionContext context = Objects.requireNonNull(this.getExecutionContext());
        DBPDataSourceContainer container = context.getDataSource().getContainer();
        return new DatabaseLazyEditorInput(this.nodePath, this.nodeName, this.getDefaultPageId(), this.getDefaultFolderId(), container.getId(), this.getClass().getName(), container.getProject(), container, false);
    }
}

