/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.dameng.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.dameng.model.DamengSchema;
import org.jkiss.dbeaver.ext.generic.model.GenericSequence;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;

public class DamengSequenceManager
extends SQLObjectEditor<GenericSequence, DamengSchema> {
    public long getMakerOptions(DBPDataSource dataSource) {
        return 4L;
    }

    public DBSObjectCache<? extends DBSObject, GenericSequence> getObjectsCache(GenericSequence object) {
        return null;
    }

    protected GenericSequence createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, Object container, Object copyFrom, Map<String, Object> options) throws DBException {
        GenericStructContainer structContainer = (GenericStructContainer)container;
        DamengSchema schema = (DamengSchema)structContainer.getSchema();
        GenericSequence sequence = new GenericSequence((GenericStructContainer)container, "NEW_SEQUENCE", null, (Number)0, (Number)1, (Number)Long.MAX_VALUE, (Number)1);
        this.setNewObjectName(monitor, (DBSObject)schema, (DBSObject)sequence);
        return sequence;
    }

    protected void addObjectCreateActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand command, Map<String, Object> options) throws DBException {
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create sequence", this.buildStatement((GenericSequence)command.getObject(), false)));
    }

    protected void addObjectModifyActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) throws DBException {
        actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Alter Sequence", this.buildStatement((GenericSequence)command.getObject(), false)));
    }

    protected void addObjectDeleteActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) throws DBException {
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop sequence", "DROP SEQUENCE " + ((GenericSequence)command.getObject()).getFullyQualifiedName(DBPEvaluationContext.DDL)));
    }

    public String buildStatement(GenericSequence sequence, boolean forUpdate) {
        Number incrementBy = sequence.getIncrementBy();
        Number start = sequence.getMinValue();
        Number maxValue = sequence.getMaxValue();
        Number minValue = sequence.getMinValue();
        StringBuilder sb = new StringBuilder();
        if (forUpdate) {
            sb.append("ALTER SEQUENCE ");
        } else {
            sb.append("CREATE SEQUENCE ");
        }
        sb.append(sequence.getFullyQualifiedName(DBPEvaluationContext.DDL)).append(" ");
        if (incrementBy != null) {
            sb.append("INCREMENT BY ").append(incrementBy).append(" ");
        }
        if (start != null) {
            sb.append("START WITH ").append(start).append(" ");
        }
        if (maxValue != null) {
            sb.append("MAXVALUE ").append(maxValue).append(" ");
        }
        if (minValue != null) {
            sb.append("MINVALUE ").append(minValue).append(" ");
        }
        return sb.toString();
    }
}

