/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.net.ssh;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Locale;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPAuthInfo;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DataSourceVariableResolver;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.net.DBWTunnel;
import org.jkiss.dbeaver.model.net.ssh.SSHConstants;
import org.jkiss.dbeaver.model.net.ssh.SSHImplementationAbstract;
import org.jkiss.dbeaver.model.net.ssh.SSHTunnelImpl;
import org.jkiss.dbeaver.model.net.ssh.registry.SSHImplementationDescriptor;
import org.jkiss.dbeaver.model.net.ssh.registry.SSHImplementationRegistry;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.AbstractTrackingJob;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.IVariableResolver;
import org.jkiss.dbeaver.ui.IObjectPropertyConfigurator;
import org.jkiss.dbeaver.ui.ShellUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ConfigurationFileSelector;
import org.jkiss.dbeaver.ui.controls.VariablesHintLabel;
import org.jkiss.dbeaver.ui.net.ssh.SSHUIMessages;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.HelpUtils;
import org.jkiss.dbeaver.utils.SystemVariablesResolver;
import org.jkiss.utils.CommonUtils;

public class SSHTunnelConfiguratorUI
implements IObjectPropertyConfigurator<Object, DBWHandlerConfiguration> {
    private static final Log log = Log.getLog(SSHTunnelConfiguratorUI.class);
    private DBWHandlerConfiguration savedConfiguration;
    private CredentialsPanel credentialsPanel;
    private CredentialsPanel jumpServerCredentialsPanel;
    private Button jumpServerEnabledCheck;
    private Combo tunnelImplCombo;
    private Button fingerprintVerificationCheck;
    private Text localHostText;
    private Text localPortSpinner;
    private Text remoteHostText;
    private Text remotePortSpinner;
    private Text keepAliveText;
    private Text tunnelTimeout;
    private VariablesHintLabel variablesHintLabel;

    public void createControl(final @NotNull Composite parent, Object object, @NotNull Runnable propertyChangeListener) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(1808);
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(1, false));
        Group settingsGroup = UIUtils.createControlGroup((Composite)composite, (String)SSHUIMessages.model_ssh_configurator_group_settings, (int)2, (int)770, (int)-1);
        this.credentialsPanel = new CredentialsPanel((Composite)settingsGroup, true);
        ExpandableComposite group = new ExpandableComposite(composite, 32);
        group.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                UIUtils.resizeShell((Shell)parent.getShell());
            }
        });
        group.setLayoutData((Object)new GridData(4, 1, true, false));
        group.setText(SSHUIMessages.model_ssh_configurator_group_jump_server_settings_text);
        Composite client = new Composite((Composite)group, 2048);
        client.setLayout((Layout)new GridLayout(2, false));
        client.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setClient((Control)client);
        this.jumpServerEnabledCheck = UIUtils.createCheckbox((Composite)client, (String)SSHUIMessages.model_ssh_configurator_group_jump_server_checkbox_label, (boolean)false);
        this.jumpServerEnabledCheck.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
        this.jumpServerCredentialsPanel = new CredentialsPanel(client, false);
        this.jumpServerEnabledCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UIUtils.enableWithChildren((Control)SSHTunnelConfiguratorUI.this.jumpServerCredentialsPanel, (boolean)SSHTunnelConfiguratorUI.this.jumpServerEnabledCheck.getSelection());
            }
        });
        if (this.jumpServerCredentialsPanel != null && this.credentialsPanel.savePasswordCheckbox != null) {
            this.credentialsPanel.savePasswordCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SSHTunnelConfiguratorUI.this.jumpServerCredentialsPanel.passwordText.setEnabled(SSHTunnelConfiguratorUI.this.credentialsPanel.savePasswordCheckbox.getSelection() && SSHTunnelConfiguratorUI.this.jumpServerEnabledCheck.getSelection());
                }
            });
        }
        group = new ExpandableComposite(composite, 0);
        group.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                UIUtils.resizeShell((Shell)parent.getShell());
            }
        });
        group.setLayoutData((Object)new GridData(4, 1, true, false));
        group.setText(SSHUIMessages.model_ssh_configurator_group_advanced);
        client = new Composite((Composite)group, 2048);
        client.setLayout((Layout)new GridLayout(4, false));
        client.setLayoutData((Object)new GridData(1808));
        group.setClient((Control)client);
        this.tunnelImplCombo = UIUtils.createLabelCombo((Composite)client, (String)SSHUIMessages.model_ssh_configurator_label_implementation, (int)12);
        GridData gd = new GridData(32);
        this.tunnelImplCombo.setLayoutData((Object)gd);
        this.tunnelImplCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SSHTunnelConfiguratorUI.this.updateJumpServerSettingsVisibility();
            }
        });
        for (SSHImplementationDescriptor it : SSHImplementationRegistry.getInstance().getDescriptors()) {
            this.tunnelImplCombo.add(it.getLabel());
        }
        this.fingerprintVerificationCheck = UIUtils.createCheckbox((Composite)client, (String)SSHUIMessages.model_ssh_configurator_label_bypass_verification, (String)SSHUIMessages.model_ssh_configurator_label_bypass_verification_description, (boolean)false, (int)2);
        this.localHostText = UIUtils.createLabelText((Composite)client, (String)SSHUIMessages.model_ssh_configurator_label_local_host, null, (int)2048, (Object)new GridData(768));
        this.localHostText.setToolTipText(SSHUIMessages.model_ssh_configurator_label_local_host_description);
        this.localHostText.setLayoutData((Object)new GridData(768));
        this.localPortSpinner = UIUtils.createLabelText((Composite)client, (String)SSHUIMessages.model_ssh_configurator_label_local_port, (String)String.valueOf(0));
        this.localPortSpinner.setToolTipText(SSHUIMessages.model_ssh_configurator_label_local_port_description);
        SSHTunnelConfiguratorUI.setNumberEditStyles(this.localPortSpinner);
        this.remoteHostText = UIUtils.createLabelText((Composite)client, (String)SSHUIMessages.model_ssh_configurator_label_remote_host, null, (int)2048, (Object)new GridData(768));
        this.remoteHostText.setToolTipText(SSHUIMessages.model_ssh_configurator_label_remote_host_description);
        this.remoteHostText.setLayoutData((Object)new GridData(768));
        this.remotePortSpinner = UIUtils.createLabelText((Composite)client, (String)SSHUIMessages.model_ssh_configurator_label_remote_port, (String)String.valueOf(0));
        this.remotePortSpinner.setToolTipText(SSHUIMessages.model_ssh_configurator_label_remote_port_description);
        SSHTunnelConfiguratorUI.setNumberEditStyles(this.remotePortSpinner);
        UIUtils.createHorizontalLine((Composite)client, (int)4, (int)0);
        this.keepAliveText = UIUtils.createLabelText((Composite)client, (String)SSHUIMessages.model_ssh_configurator_label_keep_alive, (String)String.valueOf(0));
        SSHTunnelConfiguratorUI.setNumberEditStyles(this.keepAliveText);
        this.tunnelTimeout = UIUtils.createLabelText((Composite)client, (String)SSHUIMessages.model_ssh_configurator_label_tunnel_timeout, (String)String.valueOf(10000));
        SSHTunnelConfiguratorUI.setNumberEditStyles(this.tunnelTimeout);
        Composite controlGroup = UIUtils.createComposite((Composite)parent, (int)3);
        controlGroup.setLayoutData((Object)new GridData(768));
        UIUtils.createDialogButton((Composite)controlGroup, (String)SSHUIMessages.model_ssh_configurator_button_test_tunnel, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SSHTunnelConfiguratorUI.this.testTunnelConnection();
            }
        });
        String hint = SSHUIMessages.model_ssh_configurator_variables_hint_label;
        this.variablesHintLabel = new VariablesHintLabel(controlGroup, hint, hint, DBPConnectionConfiguration.INTERNAL_CONNECT_VARIABLES, false);
        UIUtils.createLink((Composite)controlGroup, (String)SSHUIMessages.model_ssh_configurator_ssh_documentation_link, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ShellUtils.launchProgram((String)HelpUtils.getHelpExternalReference((String)"SSH-Configuration"));
            }
        });
        UIUtils.executeOnResize((Control)parent, () -> parent.getParent().layout(true, true));
    }

    private static void setNumberEditStyles(Text text) {
        text.addVerifyListener(UIUtils.getNumberVerifyListener((Locale)Locale.ENGLISH));
        GridData gdt = new GridData(32);
        gdt.widthHint = UIUtils.getFontHeight((Control)text) * 7;
        text.setLayoutData((Object)gdt);
    }

    @Nullable
    private static DBPAuthInfo promptCredentialsDialog(@NotNull SSHConstants.AuthType type, @NotNull String username, @NotNull String password) {
        try {
            return DBWorkbench.getPlatformUI().promptUserCredentials(SSHUIMessages.model_ssh_dialog_credentials, SSHUIMessages.model_ssh_dialog_credentials_username, username, type.equals((Object)SSHConstants.AuthType.PUBLIC_KEY) ? SSHUIMessages.model_ssh_dialog_credentials_passphrase : SSHUIMessages.model_ssh_dialog_credentials_password, password, false, false);
        }
        catch (Exception e) {
            DBWorkbench.getPlatformUI().showError(CoreMessages.dialog_connection_wizard_start_dialog_error_title, e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private void testTunnelConnection() {
        block4: {
            final DBWHandlerConfiguration configuration = new DBWHandlerConfiguration(this.savedConfiguration);
            configuration.setProperties(Collections.emptyMap());
            this.saveSettings(configuration);
            DBPDataSourceContainer dataSource = configuration.getDataSource();
            if (dataSource != null) {
                configuration.resolveDynamicVariables((IVariableResolver)new DataSourceVariableResolver(dataSource, dataSource.getConnectionConfiguration()));
            } else {
                configuration.resolveDynamicVariables((IVariableResolver)SystemVariablesResolver.INSTANCE);
            }
            final String[] tunnelVersions = new String[2];
            AbstractTrackingJob job = new AbstractTrackingJob("Test tunnel connection"){

                protected void execute(@NotNull DBRProgressMonitor monitor) throws Throwable {
                    monitor.beginTask("Instantiate SSH tunnel", 2);
                    SSHTunnelImpl tunnel = new SSHTunnelImpl();
                    DBPConnectionConfiguration connectionConfig = new DBPConnectionConfiguration();
                    connectionConfig.setHostName("localhost");
                    connectionConfig.setHostPort(configuration.getStringProperty("port"));
                    try {
                        monitor.subTask("Initialize tunnel");
                        String authTypeName = configuration.getStringProperty("authType");
                        SSHConstants.AuthType authType = (SSHConstants.AuthType)CommonUtils.valueOf(SSHConstants.AuthType.class, (String)authTypeName);
                        if (!configuration.isSavePassword() && tunnel.getRequiredCredentials(configuration, null) != DBWTunnel.AuthCredentials.NONE) {
                            DBPAuthInfo dbpAuthInfo = SSHTunnelConfiguratorUI.promptCredentialsDialog(authType, configuration.getUserName(), configuration.getPassword());
                            if (dbpAuthInfo != null) {
                                configuration.setUserName(dbpAuthInfo.getUserName());
                                configuration.setPassword(dbpAuthInfo.getUserPassword());
                            }
                            this.checkJumpServerConfiguration(tunnel);
                        }
                        tunnel.initializeHandler(monitor, configuration, connectionConfig);
                        try {
                            monitor.worked(1);
                            tunnelVersions[0] = tunnel.getImplementation().getClientVersion();
                            tunnelVersions[1] = tunnel.getImplementation().getServerVersion();
                        }
                        finally {
                            monitor.subTask("Close tunnel");
                            tunnel.closeTunnel(monitor);
                        }
                        monitor.worked(1);
                    }
                    finally {
                        monitor.done();
                    }
                }

                private void checkJumpServerConfiguration(SSHTunnelImpl tunnel) {
                    if (configuration.getBooleanProperty(String.valueOf(SSHTunnelConfiguratorUI.this.getJumpServerSettingsPrefix()) + "enabled")) {
                        DBPAuthInfo dbpAuthInfo;
                        String authTypeName = configuration.getStringProperty(String.valueOf(SSHTunnelConfiguratorUI.this.getJumpServerSettingsPrefix()) + "authType");
                        SSHConstants.AuthType authType = (SSHConstants.AuthType)CommonUtils.valueOf(SSHConstants.AuthType.class, (String)authTypeName, (Enum)SSHConstants.AuthType.PASSWORD);
                        if (tunnel.getRequiredCredentials(configuration, SSHTunnelConfiguratorUI.this.getJumpServerSettingsPrefix()) != DBWTunnel.AuthCredentials.NONE && (dbpAuthInfo = SSHTunnelConfiguratorUI.promptCredentialsDialog(authType, configuration.getStringProperty(String.valueOf(SSHTunnelConfiguratorUI.this.getJumpServerSettingsPrefix()) + "name"), configuration.getSecureProperty(String.valueOf(SSHTunnelConfiguratorUI.this.getJumpServerSettingsPrefix()) + "password"))) != null) {
                            configuration.setProperty(String.valueOf(SSHTunnelConfiguratorUI.this.getJumpServerSettingsPrefix()) + "name", (Object)dbpAuthInfo.getUserName());
                            configuration.setSecureProperty(String.valueOf(SSHTunnelConfiguratorUI.this.getJumpServerSettingsPrefix()) + "password", dbpAuthInfo.getUserPassword());
                        }
                    }
                }
            };
            try {
                AbstractTrackingJob.executeInProgressMonitor((AbstractTrackingJob)job);
                MessageDialog.openInformation((Shell)this.credentialsPanel.getShell(), (String)ModelMessages.dialog_connection_wizard_start_connection_monitor_success, (String)("Connected!\n\nClient version: " + tunnelVersions[0] + "\nServer version: " + tunnelVersions[1]));
            }
            catch (InvocationTargetException ex) {
                if (ex.getTargetException() == null) break block4;
                DBWorkbench.getPlatformUI().showError(CoreMessages.dialog_connection_wizard_start_dialog_error_title, null, GeneralUtils.makeExceptionStatus((Throwable)ex.getTargetException()));
            }
        }
    }

    @NotNull
    private String getJumpServerSettingsPrefix() {
        return SSHImplementationAbstract.getJumpServerSettingsPrefix((int)0);
    }

    public void loadSettings(@NotNull DBWHandlerConfiguration configuration) {
        int timeoutValue;
        int kaValue;
        this.credentialsPanel.loadSettings(configuration, "");
        String jumpServerSettingsPrefix = this.getJumpServerSettingsPrefix();
        this.jumpServerCredentialsPanel.loadSettings(configuration, jumpServerSettingsPrefix);
        this.jumpServerEnabledCheck.setSelection(configuration.getBooleanProperty(String.valueOf(jumpServerSettingsPrefix) + "enabled"));
        if (this.credentialsPanel.savePasswordCheckbox != null) {
            this.jumpServerCredentialsPanel.passwordText.setEnabled(this.credentialsPanel.savePasswordCheckbox.getSelection());
            if (!this.credentialsPanel.savePasswordCheckbox.getSelection()) {
                this.jumpServerCredentialsPanel.passwordText.setText("");
            }
        }
        UIUtils.enableWithChildren((Control)this.jumpServerCredentialsPanel, (boolean)this.jumpServerEnabledCheck.getSelection());
        String implType = configuration.getStringProperty("implementation");
        if (CommonUtils.isEmpty((String)implType)) {
            this.tunnelImplCombo.setText("SSHJ");
            if (this.tunnelImplCombo.getSelectionIndex() == -1) {
                this.tunnelImplCombo.select(0);
            }
        } else {
            SSHImplementationDescriptor desc = SSHImplementationRegistry.getInstance().getDescriptor(implType);
            if (desc != null) {
                this.tunnelImplCombo.setText(desc.getLabel());
            } else {
                this.tunnelImplCombo.select(0);
            }
        }
        this.fingerprintVerificationCheck.setSelection(configuration.getBooleanProperty("bypassHostVerification"));
        this.localHostText.setText(CommonUtils.notEmpty((String)configuration.getStringProperty("localHost")));
        int lpValue = configuration.getIntProperty("localPort");
        if (lpValue != 0) {
            this.localPortSpinner.setText(String.valueOf(lpValue));
        }
        this.remoteHostText.setText(CommonUtils.notEmpty((String)configuration.getStringProperty("remoteHost")));
        int rpValue = configuration.getIntProperty("remotePort");
        if (rpValue != 0) {
            this.remotePortSpinner.setText(String.valueOf(rpValue));
        }
        if ((kaValue = configuration.getIntProperty("aliveInterval")) != 0) {
            this.keepAliveText.setText(String.valueOf(kaValue));
        }
        if ((timeoutValue = configuration.getIntProperty("sshConnectTimeout")) != 0) {
            this.tunnelTimeout.setText(String.valueOf(timeoutValue));
        }
        this.savedConfiguration = new DBWHandlerConfiguration(configuration);
        DBPDataSourceContainer dataSource = this.savedConfiguration.getDataSource();
        if (dataSource != null) {
            this.variablesHintLabel.setResolver((IVariableResolver)new DataSourceVariableResolver(dataSource, dataSource.getConnectionConfiguration()));
        }
        this.updateJumpServerSettingsVisibility();
    }

    public void saveSettings(@NotNull DBWHandlerConfiguration configuration) {
        this.credentialsPanel.saveSettings(configuration, "");
        boolean jumpServersEnabled = this.jumpServerEnabledCheck.getSelection();
        if (jumpServersEnabled) {
            String jumpServerSettingsPrefix = this.getJumpServerSettingsPrefix();
            this.jumpServerCredentialsPanel.saveSettings(configuration, jumpServerSettingsPrefix);
            configuration.setProperty(String.valueOf(jumpServerSettingsPrefix) + "enabled", (Object)jumpServersEnabled);
        }
        String implLabel = this.tunnelImplCombo.getText();
        for (SSHImplementationDescriptor it : SSHImplementationRegistry.getInstance().getDescriptors()) {
            if (!it.getLabel().equals(implLabel)) continue;
            configuration.setProperty("implementation", (Object)it.getId());
            break;
        }
        if (this.fingerprintVerificationCheck.getSelection()) {
            configuration.setProperty("bypassHostVerification", (Object)true);
        } else {
            configuration.setProperty("bypassHostVerification", null);
        }
        configuration.setProperty("localHost", (Object)this.localHostText.getText().trim());
        int localPort = CommonUtils.toInt((Object)this.localPortSpinner.getText());
        if (localPort <= 0) {
            configuration.setProperty("localPort", null);
        } else {
            configuration.setProperty("localPort", (Object)localPort);
        }
        configuration.setProperty("remoteHost", (Object)this.remoteHostText.getText().trim());
        int remotePort = CommonUtils.toInt((Object)this.remotePortSpinner.getText());
        if (remotePort <= 0) {
            configuration.setProperty("remotePort", null);
        } else {
            configuration.setProperty("remotePort", (Object)remotePort);
        }
        int kaInterval = CommonUtils.toInt((Object)this.keepAliveText.getText());
        if (kaInterval <= 0) {
            configuration.setProperty("aliveInterval", null);
        } else {
            configuration.setProperty("aliveInterval", (Object)kaInterval);
        }
        int conTimeout = CommonUtils.toInt((Object)this.tunnelTimeout.getText());
        if (conTimeout != 0 && conTimeout != 10000) {
            configuration.setProperty("sshConnectTimeout", (Object)conTimeout);
        }
    }

    public void resetSettings(@NotNull DBWHandlerConfiguration configuration) {
    }

    public boolean isComplete() {
        return false;
    }

    private void updateJumpServerSettingsVisibility() {
    }

    private static class CredentialsPanel
    extends Composite {
        private final Text hostNameText;
        private final Text hostPortText;
        private final Text userNameText;
        private final Combo authMethodCombo;
        private final Label privateKeyLabel;
        private final ConfigurationFileSelector privateKeyText;
        private final Label passwordLabel;
        private final Text passwordText;
        private final Button savePasswordCheckbox;

        public CredentialsPanel(@NotNull Composite parent, boolean showSavePasswordCheckbox) {
            super(parent, 0);
            this.setLayout((Layout)new GridLayout(2, false));
            this.setLayoutData(new GridData(1808));
            UIUtils.createControlLabel((Composite)this, (String)SSHUIMessages.model_ssh_configurator_label_host_ip);
            Composite hostPortComp = UIUtils.createComposite((Composite)this, (int)3);
            hostPortComp.setLayoutData((Object)new GridData(768));
            this.hostNameText = new Text(hostPortComp, 2048);
            this.hostNameText.setLayoutData((Object)new GridData(768));
            this.hostPortText = UIUtils.createLabelText((Composite)hostPortComp, (String)SSHUIMessages.model_ssh_configurator_label_port, (String)String.valueOf(22));
            SSHTunnelConfiguratorUI.setNumberEditStyles(this.hostPortText);
            this.userNameText = UIUtils.createLabelText((Composite)this, (String)SSHUIMessages.model_ssh_configurator_label_user_name, null, (int)2048, (Object)new GridData(768));
            this.authMethodCombo = UIUtils.createLabelCombo((Composite)this, (String)SSHUIMessages.model_ssh_configurator_combo_auth_method, (int)12);
            this.authMethodCombo.setLayoutData((Object)new GridData(32));
            this.authMethodCombo.add(SSHUIMessages.model_ssh_configurator_combo_password);
            this.authMethodCombo.add(SSHUIMessages.model_ssh_configurator_combo_pub_key);
            this.authMethodCombo.add(SSHUIMessages.model_ssh_configurator_combo_agent);
            this.authMethodCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    this.updateAuthMethodVisibility();
                }
            });
            this.privateKeyLabel = UIUtils.createControlLabel((Composite)this, (String)SSHUIMessages.model_ssh_configurator_label_private_key);
            this.privateKeyLabel.setLayoutData((Object)new GridData(32));
            this.privateKeyText = new ConfigurationFileSelector((Composite)this, SSHUIMessages.model_ssh_configurator_dialog_choose_private_key, new String[]{"*", "*.ssh", "*.pem", "*.*"}, false, DBWorkbench.isDistributed());
            this.privateKeyText.setLayoutData((Object)new GridData(768));
            if (DBWorkbench.isDistributed()) {
                this.privateKeyText.getTextControl().setEditable(false);
            }
            this.passwordLabel = UIUtils.createControlLabel((Composite)this, (String)SSHUIMessages.model_ssh_configurator_label_password);
            this.privateKeyLabel.setLayoutData((Object)new GridData(32));
            Composite passComp = UIUtils.createComposite((Composite)this, (int)2);
            passComp.setLayoutData((Object)new GridData(768));
            this.passwordText = new Text(passComp, 0x400800);
            this.passwordText.setLayoutData((Object)new GridData(768));
            if (showSavePasswordCheckbox) {
                this.savePasswordCheckbox = UIUtils.createCheckbox((Composite)passComp, (String)SSHUIMessages.model_ssh_configurator_checkbox_save_pass, (boolean)false);
                this.savePasswordCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        passwordText.setEnabled(savePasswordCheckbox.getSelection());
                    }
                });
                this.savePasswordCheckbox.setLayoutData((Object)new GridData(32));
            } else {
                this.savePasswordCheckbox = null;
                ((GridData)this.passwordText.getLayoutData()).horizontalSpan = 2;
            }
        }

        public void loadSettings(@NotNull DBWHandlerConfiguration configuration, @NotNull String prefix) {
            this.hostNameText.setText(CommonUtils.notEmpty((String)configuration.getStringProperty(String.valueOf(prefix) + "host")));
            int portString = configuration.getIntProperty(String.valueOf(prefix) + "port");
            if (portString != 0) {
                this.hostPortText.setText(String.valueOf(portString));
            } else {
                this.hostPortText.setText(String.valueOf(22));
            }
            this.authMethodCombo.select(((SSHConstants.AuthType)CommonUtils.valueOf(SSHConstants.AuthType.class, (String)configuration.getStringProperty(String.valueOf(prefix) + "authType"), (Enum)SSHConstants.AuthType.PASSWORD)).ordinal());
            if (DBWorkbench.isDistributed()) {
                this.privateKeyText.setText(CommonUtils.notEmpty((String)configuration.getSecureProperty(String.valueOf(prefix) + "keyValue")));
            } else {
                this.privateKeyText.setText(CommonUtils.notEmpty((String)configuration.getStringProperty(String.valueOf(prefix) + "keyPath")));
            }
            if (prefix.isEmpty()) {
                this.userNameText.setText(CommonUtils.notEmpty((String)configuration.getUserName()));
                if (this.savePasswordCheckbox != null) {
                    this.savePasswordCheckbox.setSelection(configuration.isSavePassword());
                    this.passwordText.setEnabled(this.savePasswordCheckbox.getSelection());
                }
                if (this.savePasswordCheckbox == null || this.savePasswordCheckbox.getSelection()) {
                    this.passwordText.setText(CommonUtils.notEmpty((String)configuration.getPassword()));
                }
            } else {
                this.userNameText.setText(CommonUtils.notEmpty((String)configuration.getStringProperty(String.valueOf(prefix) + "name")));
                this.passwordText.setText(CommonUtils.notEmpty((String)configuration.getSecureProperty(String.valueOf(prefix) + "password")));
                if (this.savePasswordCheckbox != null) {
                    this.savePasswordCheckbox.setSelection(configuration.getBooleanProperty(String.valueOf(prefix) + "password"));
                }
                if (this.savePasswordCheckbox == null || this.savePasswordCheckbox.getSelection()) {
                    this.passwordText.setText(CommonUtils.notEmpty((String)configuration.getSecureProperty(String.valueOf(prefix) + "password")));
                }
            }
            this.updateAuthMethodVisibility();
        }

        public void saveSettings(@NotNull DBWHandlerConfiguration configuration, @NotNull String prefix) {
            configuration.setProperty(String.valueOf(prefix) + "host", (Object)this.hostNameText.getText().trim());
            configuration.setProperty(String.valueOf(prefix) + "port", (Object)CommonUtils.toInt((Object)this.hostPortText.getText().trim()));
            configuration.setProperty(String.valueOf(prefix) + "authType", (Object)SSHConstants.AuthType.values()[this.authMethodCombo.getSelectionIndex()].name());
            String privateKey = this.privateKeyText.getText().trim();
            if (CommonUtils.isEmpty((String)privateKey)) {
                privateKey = null;
            }
            if (DBWorkbench.isDistributed()) {
                configuration.setSecureProperty(String.valueOf(prefix) + "keyValue", privateKey);
            } else {
                configuration.setProperty(String.valueOf(prefix) + "keyPath", (Object)privateKey);
            }
            if (prefix.isEmpty()) {
                configuration.setUserName(this.userNameText.getText().trim());
                if (this.savePasswordCheckbox != null) {
                    configuration.setSavePassword(this.savePasswordCheckbox.getSelection());
                }
                if (this.savePasswordCheckbox == null || configuration.isSavePassword()) {
                    configuration.setPassword(this.passwordText.getText());
                }
            } else {
                configuration.setProperty(String.valueOf(prefix) + "name", (Object)this.userNameText.getText().trim());
                if (this.passwordText.isEnabled()) {
                    configuration.setSecureProperty(String.valueOf(prefix) + "password", this.passwordText.getText());
                }
            }
        }

        private void updateAuthMethodVisibility() {
            switch (this.authMethodCombo.getSelectionIndex()) {
                case 0: {
                    this.showPrivateKeyField(false);
                    this.showPasswordField(true, SSHUIMessages.model_ssh_configurator_label_password);
                    break;
                }
                case 1: {
                    this.showPrivateKeyField(true);
                    this.showPasswordField(true, SSHUIMessages.model_ssh_configurator_label_passphrase);
                    break;
                }
                case 2: {
                    this.showPrivateKeyField(false);
                    this.showPasswordField(false, null);
                    break;
                }
            }
            this.authMethodCombo.getShell().layout(true, true);
        }

        private void showPasswordField(boolean show, String passwordLabelText) {
            UIUtils.setControlVisible((Control)this.passwordLabel, (boolean)show);
            UIUtils.setControlVisible((Control)this.passwordText.getParent(), (boolean)show);
            if (passwordLabelText != null) {
                this.passwordLabel.setText(passwordLabelText);
            }
        }

        private void showPrivateKeyField(boolean show) {
            UIUtils.setControlVisible((Control)this.privateKeyLabel, (boolean)show);
            UIUtils.setControlVisible((Control)this.privateKeyText, (boolean)show);
        }
    }
}

