/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.preferences;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.core.commands.common.EventManager;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIElementAlignment;
import org.jkiss.dbeaver.ui.UIElementFontStyle;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.DefaultColorSelector;
import org.jkiss.dbeaver.ui.controls.TextWithDropDown;
import org.jkiss.dbeaver.ui.controls.bool.BooleanMode;
import org.jkiss.dbeaver.ui.controls.bool.BooleanState;
import org.jkiss.dbeaver.ui.controls.bool.BooleanStyle;
import org.jkiss.dbeaver.ui.controls.bool.BooleanStyleSet;
import org.jkiss.dbeaver.ui.preferences.AbstractPrefPage;
import org.jkiss.dbeaver.ui.preferences.PreferenceStoreDelegate;
import org.jkiss.dbeaver.utils.PrefUtils;
import org.jkiss.utils.CommonUtils;

public class PrefPageDatabaseEditors
extends AbstractPrefPage
implements IWorkbenchPreferencePage,
IWorkbenchPropertyPage {
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.editors";
    private Button keepEditorsOnRestart;
    private Button keepEditorsOnDisconnect;
    private Button refreshEditorOnOpen;
    private Button editorFullName;
    private Button showTableGrid;
    private Button showPreviewOnSave;
    private Button syncEditorDataSourceWithNavigator;
    private final List<Consumer<BooleanStyleSet>> booleanStylesChangeListeners = new ArrayList<Consumer<BooleanStyleSet>>();
    private BooleanPanel booleanCheckedPanel;
    private BooleanPanel booleanUncheckedPanel;
    private BooleanPanel booleanNullPanel;
    private RGB defaultColor;

    public PrefPageDatabaseEditors() {
        this.setPreferenceStore((IPreferenceStore)new PreferenceStoreDelegate(DBWorkbench.getPlatform().getPreferenceStore()));
    }

    public void init(IWorkbench workbench) {
    }

    @NotNull
    protected Control createPreferenceContent(@NotNull Composite parent) {
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)1, (int)5);
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        Group groupEditors = UIUtils.createControlGroup((Composite)composite, (String)CoreMessages.pref_page_ui_general_group_editors, (int)1, (int)2, (int)0);
        this.keepEditorsOnRestart = UIUtils.createCheckbox((Composite)groupEditors, (String)CoreMessages.pref_page_ui_general_keep_database_editors, (boolean)store.getBoolean("ui.editors.reopen-after-restart"));
        this.keepEditorsOnRestart.setToolTipText(CoreMessages.pref_page_ui_general_keep_database_editors_tip);
        this.keepEditorsOnDisconnect = UIUtils.createCheckbox((Composite)groupEditors, (String)CoreMessages.pref_page_ui_general_keep_database_editors_on_disconnect, (String)CoreMessages.pref_page_ui_general_keep_database_editors_on_disconnect_tip, (boolean)store.getBoolean("ui.editors.keep-editors-on-disconnect"), (int)1);
        this.refreshEditorOnOpen = UIUtils.createCheckbox((Composite)groupEditors, (String)CoreMessages.pref_page_ui_general_refresh_editor_on_open, (boolean)store.getBoolean("navigator.refresh.editor.open"));
        this.refreshEditorOnOpen.setToolTipText(CoreMessages.pref_page_ui_general_refresh_editor_on_open_tip);
        this.editorFullName = UIUtils.createCheckbox((Composite)groupEditors, (String)CoreMessages.pref_page_ui_general_show_full_name_in_editor, (boolean)store.getBoolean("navigator.editor.full-name"));
        this.showTableGrid = UIUtils.createCheckbox((Composite)groupEditors, (String)CoreMessages.pref_page_ui_general_show_table_grid, (boolean)store.getBoolean("navigator.editor.showGrid"));
        this.showPreviewOnSave = UIUtils.createCheckbox((Composite)groupEditors, (String)CoreMessages.pref_page_ui_general_show_preview_on_save, (boolean)store.getBoolean("navigator.editor.show.preview"));
        this.syncEditorDataSourceWithNavigator = UIUtils.createCheckbox((Composite)groupEditors, (String)CoreMessages.pref_page_database_general_label_sync_editor_connection_with_navigator, (String)CoreMessages.pref_page_database_general_label_sync_editor_connection_with_navigator_tip, (boolean)store.getBoolean("navigator.sync.editor.datasource"), (int)2);
        groupEditors = UIUtils.createControlGroup((Composite)composite, (String)CoreMessages.pref_page_ui_general_boolean, (int)3, (int)2, (int)0);
        UIUtils.createControlLabel((Composite)groupEditors, (String)CoreMessages.pref_page_ui_general_boolean_label_mode);
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
                BooleanMode mode = (BooleanMode)e.widget.getData();
                PrefPageDatabaseEditors.this.notifyBooleanStylesChanged(BooleanStyleSet.getDefaultStyles((DBPPreferenceStore)store, (BooleanMode)mode));
            }
        };
        this.booleanStylesChangeListeners.add(value -> {
            this.booleanCheckedPanel.loadStyle(value.getCheckedStyle(), value.getDefaultColor());
            this.booleanUncheckedPanel.loadStyle(value.getUncheckedStyle(), value.getDefaultColor());
            this.booleanNullPanel.loadStyle(value.getNullStyle(), value.getDefaultColor());
            this.defaultColor = value.getDefaultColor();
        });
        BooleanMode[] booleanModeArray = BooleanMode.values();
        int n = booleanModeArray.length;
        int n2 = 0;
        while (n2 < n) {
            BooleanMode mode = booleanModeArray[n2];
            Button button = UIUtils.createRadioButton((Composite)groupEditors, (String)mode.getName(), (Object)mode, null);
            button.setToolTipText(mode.getDescription());
            button.addSelectionListener((SelectionListener)selectionListener);
            button.setData((Object)mode);
            this.booleanStylesChangeListeners.add(value -> button.setSelection(button.getData() == value.getMode()));
            ++n2;
        }
        Composite group = new Composite((Composite)groupEditors, 2048);
        group.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(7).create());
        group.setLayoutData((Object)GridDataFactory.swtDefaults().span(3, 1).create());
        UIUtils.createLabel((Composite)group, (String)CoreMessages.pref_page_ui_general_boolean_label_state);
        UIUtils.createPlaceholder((Composite)group, (int)1);
        UIUtils.createControlLabel((Composite)group, (String)CoreMessages.pref_page_ui_general_boolean_label_text);
        UIUtils.createPlaceholder((Composite)group, (int)1);
        UIUtils.createControlLabel((Composite)group, (String)CoreMessages.pref_page_ui_general_boolean_label_align);
        UIUtils.createPlaceholder((Composite)group, (int)1);
        UIUtils.createControlLabel((Composite)group, (String)CoreMessages.pref_page_ui_general_boolean_label_color);
        this.booleanCheckedPanel = new BooleanPanel(group, BooleanState.CHECKED);
        this.booleanUncheckedPanel = new BooleanPanel(group, BooleanState.UNCHECKED);
        this.booleanNullPanel = new BooleanPanel(group, BooleanState.NULL);
        this.notifyBooleanStylesChanged(BooleanStyleSet.getDefaultStyles((DBPPreferenceStore)DBWorkbench.getPlatform().getPreferenceStore()));
        return composite;
    }

    protected void performDefaults() {
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        this.keepEditorsOnRestart.setSelection(store.getDefaultBoolean("ui.editors.reopen-after-restart"));
        this.keepEditorsOnDisconnect.setSelection(store.getDefaultBoolean("ui.editors.keep-editors-on-disconnect"));
        this.refreshEditorOnOpen.setSelection(store.getDefaultBoolean("navigator.refresh.editor.open"));
        this.editorFullName.setSelection(store.getDefaultBoolean("navigator.editor.full-name"));
        this.showTableGrid.setSelection(store.getDefaultBoolean("navigator.editor.showGrid"));
        this.showPreviewOnSave.setSelection(store.getDefaultBoolean("navigator.editor.show.preview"));
        this.syncEditorDataSourceWithNavigator.setSelection(store.getDefaultBoolean("navigator.sync.editor.datasource"));
        this.notifyBooleanStylesChanged(BooleanStyleSet.getDefaultStyleSet());
    }

    public boolean performOk() {
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        store.setValue("ui.editors.reopen-after-restart", this.keepEditorsOnRestart.getSelection());
        store.setValue("ui.editors.keep-editors-on-disconnect", this.keepEditorsOnDisconnect.getSelection());
        store.setValue("navigator.refresh.editor.open", this.refreshEditorOnOpen.getSelection());
        store.setValue("navigator.editor.full-name", this.editorFullName.getSelection());
        store.setValue("navigator.editor.showGrid", this.showTableGrid.getSelection());
        store.setValue("navigator.editor.show.preview", this.showPreviewOnSave.getSelection());
        store.setValue("navigator.sync.editor.datasource", this.syncEditorDataSourceWithNavigator.getSelection());
        BooleanStyleSet.setDefaultStyles((DBPPreferenceStore)store, (BooleanStyleSet)new BooleanStyleSet(this.booleanCheckedPanel.saveStyle(), this.booleanUncheckedPanel.saveStyle(), this.booleanNullPanel.saveStyle(), this.defaultColor));
        PrefUtils.savePreferenceStore((DBPPreferenceStore)store);
        return true;
    }

    public void applyData(Object data) {
        super.applyData(data);
    }

    @Nullable
    public IAdaptable getElement() {
        return null;
    }

    public void setElement(IAdaptable element) {
    }

    private void notifyBooleanStylesChanged(@NotNull BooleanStyleSet set) {
        for (Consumer<BooleanStyleSet> listener : this.booleanStylesChangeListeners) {
            listener.accept(set);
        }
    }

    private void updateBooleanValidState() {
        boolean valid;
        boolean bl = valid = this.booleanCheckedPanel.isValid() && this.booleanUncheckedPanel.isValid() && this.booleanNullPanel.isValid();
        if (valid) {
            this.setErrorMessage(null);
            this.setValid(true);
        } else {
            this.setErrorMessage(CoreMessages.pref_page_ui_general_boolean_invalid_values);
            this.setValid(false);
        }
    }

    private class BooleanPanel
    extends EventManager {
        private static final String PROP_MODE = "modeValue";
        private static final String PROP_FONT = "fontValue";
        private static final String PROP_TEXT = "textValue";
        private static final String PROP_ALIGN = "alignValue";
        private static final String PROP_COLOR = "colorValue";
        private static final String PROP_DEFAULT_COLOR = "defaultColorValue";
        private static final int MENU_PRESET_ID = 1;
        private static final int MENU_FONT_ID = 2;
        private static final int MENU_RESET_COLOR_ID = 3;
        private final Composite parent;
        private final BooleanState state;
        private final Font normalFont;
        private final Font boldFont;
        private final Font italicFont;
        private BooleanMode currentMode;
        private String currentText;
        private UIElementAlignment currentAlignment;
        private UIElementFontStyle currentFontStyle;
        private RGB currentColor;
        private RGB currentDefaultColor;

        public BooleanPanel(@NotNull Composite parent, BooleanState state) {
            UIElementAlignment alignment;
            this.parent = parent;
            this.state = state;
            FontDescriptor fontDescriptor = FontDescriptor.createFrom((Font)parent.getFont());
            this.normalFont = parent.getFont();
            this.boldFont = fontDescriptor.setStyle(1).createFont((Device)parent.getDisplay());
            this.italicFont = fontDescriptor.setStyle(2).createFont((Device)parent.getDisplay());
            parent.addDisposeListener(e -> {
                UIUtils.dispose((Resource)this.boldFont);
                UIUtils.dispose((Resource)this.italicFont);
            });
            Label icon = UIUtils.createLabel((Composite)parent, (DBPImage)state.getIcon());
            icon.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
            icon.setToolTipText(state.getLabel());
            UIUtils.createLabel((Composite)parent, (DBPImage)UIIcon.SEPARATOR_V);
            ModifyListener textModifyListener = e -> {
                this.currentText = ((Text)e.widget).getText();
                PrefPageDatabaseEditors.this.updateBooleanValidState();
            };
            SelectionAdapter menuSelectionListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MenuItem menu = (MenuItem)e.widget;
                    switch (menu.getID()) {
                        case 1: {
                            BooleanPanel.this.notifyPropertyChanged(e.widget, BooleanPanel.PROP_TEXT, menu.getText());
                            break;
                        }
                        case 2: {
                            BooleanPanel.this.notifyPropertyChanged(e.widget, BooleanPanel.PROP_FONT, menu.getData());
                            break;
                        }
                        case 3: {
                            BooleanPanel.this.notifyPropertyChanged(e.widget, BooleanPanel.PROP_COLOR, BooleanPanel.this.currentDefaultColor);
                        }
                    }
                }
            };
            UIElementAlignment[] uIElementAlignmentArray = UIElementAlignment.values();
            int n = uIElementAlignmentArray.length;
            int n2 = 0;
            while (n2 < n) {
                alignment = uIElementAlignmentArray[n2];
                TextWithDropDown text = new TextWithDropDown(parent, 2048, alignment.getStyle(), (SelectionListener)menuSelectionListener);
                text.getTextComponent().addModifyListener(textModifyListener);
                text.setData((Object)alignment);
                String[] stringArray = state.getPresets();
                int n3 = stringArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    String variant = stringArray[n4];
                    text.addMenuItem(variant).setID(1);
                    ++n4;
                }
                text.addMenuSeparator();
                text.addMenuItemWithMenu(CoreMessages.pref_page_ui_general_boolean_styles, null, menu -> {
                    UIElementFontStyle[] uIElementFontStyleArray = UIElementFontStyle.values();
                    int n = uIElementFontStyleArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        UIElementFontStyle value = uIElementFontStyleArray[n2];
                        MenuItem item = text.addMenuItem(menu, value.getLabel(), null, (Object)value, 16);
                        item.setID(2);
                        this.addPropertyChangeListener(event -> {
                            if (event.getProperty().equals(PROP_FONT)) {
                                item.setSelection(event.getNewValue() == item.getData());
                            }
                        });
                        ++n2;
                    }
                });
                text.addMenuItemWithMenu(CoreMessages.pref_page_ui_general_boolean_color, null, menu -> {
                    MenuItem item = text.addMenuItem(menu, CoreMessages.pref_page_ui_general_boolean_color_use_theme_color, null, null, 32);
                    item.setID(3);
                    this.addPropertyChangeListener(event -> {
                        if (event.getProperty().equals(PROP_COLOR)) {
                            item.setSelection(event.getNewValue() == this.currentDefaultColor);
                        }
                    });
                });
                ((GridData)text.getLayoutData()).widthHint = 120;
                this.addPropertyChangeListener(event -> {
                    switch (event.getProperty()) {
                        case "textValue": {
                            text.getTextComponent().setText((String)event.getNewValue());
                            break;
                        }
                        case "fontValue": {
                            switch ((UIElementFontStyle)event.getNewValue()) {
                                case NORMAL: {
                                    text.getTextComponent().setFont(this.normalFont);
                                    break;
                                }
                                case ITALIC: {
                                    text.getTextComponent().setFont(this.italicFont);
                                    break;
                                }
                                case BOLD: {
                                    text.getTextComponent().setFont(this.boldFont);
                                }
                            }
                            break;
                        }
                        case "modeValue": {
                            UIUtils.enableWithChildren((Control)text, (event.getNewValue() == BooleanMode.TEXT ? 1 : 0) != 0);
                            break;
                        }
                        case "colorValue": {
                            text.getTextComponent().setForeground(UIUtils.getSharedColor((RGB)((RGB)event.getNewValue())));
                            break;
                        }
                        case "alignValue": {
                            UIUtils.setControlVisible((Control)text, (event.getNewValue() == text.getData() ? 1 : 0) != 0);
                            text.getTextComponent().setText(this.currentText);
                        }
                    }
                });
                ++n2;
            }
            UIUtils.createLabel((Composite)parent, (DBPImage)UIIcon.SEPARATOR_V);
            ToolBar alignToolBar = new ToolBar(parent, 256);
            alignToolBar.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
            SelectionAdapter selectionListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (((ToolItem)e.widget).getSelection()) {
                        BooleanPanel.this.notifyPropertyChanged(e.widget, BooleanPanel.PROP_ALIGN, e.widget.getData());
                    }
                }
            };
            uIElementAlignmentArray = UIElementAlignment.values();
            n = uIElementAlignmentArray.length;
            n2 = 0;
            while (n2 < n) {
                alignment = uIElementAlignmentArray[n2];
                ToolItem item = new ToolItem(alignToolBar, 16);
                item.setImage(DBeaverIcons.getImage((DBPImage)alignment.getIcon()));
                item.setToolTipText(alignment.getLabel());
                item.addSelectionListener((SelectionListener)selectionListener);
                item.setData((Object)alignment);
                this.addPropertyChangeListener(event -> {
                    if (event.getProperty().equals(PROP_ALIGN)) {
                        item.setSelection(event.getNewValue() == item.getData());
                    }
                });
                ++n2;
            }
            UIUtils.createLabel((Composite)parent, (DBPImage)UIIcon.SEPARATOR_V);
            DefaultColorSelector selector = new DefaultColorSelector(parent, false);
            selector.setColorValue(new RGB(0, 0, 0));
            selector.setDefaultColorValue(new RGB(0, 0, 0));
            selector.addListener(e -> this.notifyPropertyChanged(selector, PROP_COLOR, selector.getColorValue()));
            this.addPropertyChangeListener(event -> {
                if (event.getSource() == selector) {
                    return;
                }
                switch (event.getProperty()) {
                    case "modeValue": {
                        selector.setEnabled(event.getNewValue() == BooleanMode.TEXT);
                        break;
                    }
                    case "colorValue": {
                        selector.setColorValue((RGB)event.getNewValue());
                        break;
                    }
                    case "defaultColorValue": {
                        selector.setDefaultColorValue((RGB)event.getNewValue());
                    }
                }
            });
            this.addPropertyChangeListener(event -> {
                switch (event.getProperty()) {
                    case "modeValue": {
                        this.currentMode = (BooleanMode)event.getNewValue();
                        break;
                    }
                    case "textValue": {
                        this.currentText = (String)event.getNewValue();
                        break;
                    }
                    case "alignValue": {
                        this.currentAlignment = (UIElementAlignment)event.getNewValue();
                        this.parent.layout(true);
                        break;
                    }
                    case "fontValue": {
                        this.currentFontStyle = (UIElementFontStyle)event.getNewValue();
                        break;
                    }
                    case "colorValue": {
                        this.currentColor = (RGB)event.getNewValue();
                        break;
                    }
                    case "defaultColorValue": {
                        this.currentDefaultColor = (RGB)event.getNewValue();
                    }
                }
                PrefPageDatabaseEditors.this.updateBooleanValidState();
            });
        }

        public void loadStyle(@NotNull BooleanStyle style, @NotNull RGB defaultColor) {
            if (style.getMode() == BooleanMode.TEXT) {
                this.notifyPropertyChanged((Object)this, PROP_TEXT, style.getText());
                this.notifyPropertyChanged((Object)this, PROP_FONT, style.getFontStyle());
                this.notifyPropertyChanged((Object)this, PROP_DEFAULT_COLOR, defaultColor);
                this.notifyPropertyChanged((Object)this, PROP_COLOR, style.getColor());
            } else {
                this.notifyPropertyChanged((Object)this, PROP_TEXT, "");
            }
            this.notifyPropertyChanged((Object)this, PROP_ALIGN, style.getAlignment());
            this.notifyPropertyChanged((Object)this, PROP_MODE, style.getMode());
        }

        @NotNull
        public BooleanStyle saveStyle() {
            if (this.currentMode == BooleanMode.TEXT) {
                return BooleanStyle.usingText((String)this.currentText, (UIElementAlignment)this.currentAlignment, (RGB)this.currentColor, (UIElementFontStyle)this.currentFontStyle);
            }
            return BooleanStyle.usingIcon((DBIcon)this.state.getIcon(), (UIElementAlignment)this.currentAlignment);
        }

        public boolean isValid() {
            return this.currentMode == BooleanMode.ICON || !CommonUtils.isEmptyTrimmed((String)this.currentText);
        }

        public void addPropertyChangeListener(@NotNull IPropertyChangeListener listener) {
            this.addListenerObject(listener);
        }

        public void notifyPropertyChanged(@NotNull Object source, @NotNull String property, @Nullable Object value) {
            Object[] listeners = this.getListeners();
            if (listeners.length > 0) {
                PropertyChangeEvent event = new PropertyChangeEvent(source, property, null, value);
                Object[] objectArray = listeners;
                int n = listeners.length;
                int n2 = 0;
                while (n2 < n) {
                    Object listener = objectArray[n2];
                    ((IPropertyChangeListener)listener).propertyChange(event);
                    ++n2;
                }
            }
        }
    }
}

