/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.actions;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceContainerProvider;
import org.jkiss.dbeaver.model.DBPDataSourceProvider;
import org.jkiss.dbeaver.model.DBPDataSourceProviderSynchronizable;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCSavepoint;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.DBCTransactionManager;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.qm.QMExecutionHandler;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.runtime.IPluginService;
import org.jkiss.dbeaver.runtime.qm.DefaultExecutionHandler;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.ui.editors.IStatefulEditor;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class DataSourcePropertyTester
extends PropertyTester {
    protected static final Log log = Log.getLog(DataSourcePropertyTester.class);
    public static final String NAMESPACE = "org.jkiss.dbeaver.core.datasource";
    public static final String PROP_CONNECTED = "connected";
    public static final String PROP_TRANSACTIONAL = "transactional";
    public static final String PROP_SYNCHRONIZABLE = "synchronizable";
    public static final String PROP_SUPPORTS_TRANSACTIONS = "supportsTransactions";
    public static final String PROP_TRANSACTION_ACTIVE = "transactionActive";
    public static final String PROP_EDITABLE = "editable";
    public static final String PROP_PROJECT_RESOURCE_EDITABLE = "projectResourceEditable";
    public static final String PROP_PROJECT_RESOURCE_VIEWABLE = "projectResourceViewable";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        try {
            while (true) {
                if (!(receiver instanceof DBNDatabaseNode) || receiver instanceof DBNDataSource) {
                    if (receiver instanceof DBPContextProvider) break;
                    return false;
                }
                receiver = ((DBNDatabaseNode)receiver).getParentNode();
            }
            DBPContextProvider contextProvider = (DBPContextProvider)receiver;
            DBCExecutionContext context = contextProvider.getExecutionContext();
            DBPProject resourceProject = receiver instanceof IEditorPart ? EditorUtils.getFileProject((IEditorInput)((IEditorPart)receiver).getEditorInput()) : null;
            switch (property) {
                case "connected": {
                    DBPDataSourceContainer container;
                    boolean isConnected = context != null ? context.getDataSource().getContainer().isConnected() : (receiver instanceof DBPDataSourceContainerProvider ? (container = ((DBPDataSourceContainerProvider)receiver).getDataSourceContainer()) != null && container.isConnected() : false);
                    boolean checkConnected = Boolean.TRUE.equals(expectedValue);
                    return checkConnected == isConnected;
                }
                case "transactional": {
                    if (context == null) {
                        return false;
                    }
                    if (!context.isConnected()) {
                        return Boolean.FALSE.equals(expectedValue);
                    }
                    DBCTransactionManager txnManager = DBUtils.getTransactionManager((DBCExecutionContext)context);
                    try {
                        return txnManager != null && Boolean.valueOf(!txnManager.isAutoCommit()).equals(expectedValue);
                    }
                    catch (DBCException e) {
                        log.debug((Object)"Error checking auto-commit state", (Throwable)e);
                        return false;
                    }
                }
                case "synchronizable": {
                    if (context == null || !context.isConnected()) {
                        return false;
                    }
                    DBPDataSourceContainer container = context.getDataSource().getContainer();
                    DBPDataSourceProvider provider = container.getDriver().getDataSourceProvider();
                    DBPDataSourceProviderSynchronizable providerSynchronizable = (DBPDataSourceProviderSynchronizable)GeneralUtils.adapt((Object)provider, DBPDataSourceProviderSynchronizable.class);
                    return providerSynchronizable != null && providerSynchronizable.isSynchronizationEnabled(container);
                }
                case "supportsTransactions": {
                    if (context == null || !context.isConnected()) {
                        return false;
                    }
                    DBCTransactionManager txnManager = DBUtils.getTransactionManager((DBCExecutionContext)context);
                    return txnManager != null && txnManager.isSupportsTransactions();
                }
                case "transactionActive": {
                    if (context != null && context.isConnected()) {
                        DBCTransactionManager txnManager = DBUtils.getTransactionManager((DBCExecutionContext)context);
                        return txnManager != null && !txnManager.isAutoCommit();
                    }
                    return Boolean.FALSE.equals(expectedValue);
                }
                case "editable": {
                    return resourceProject == null || resourceProject.hasRealmPermission("project-datasource-edit");
                }
                case "projectResourceEditable": {
                    return resourceProject == null || resourceProject.hasRealmPermission("project-resource-edit");
                }
                case "projectResourceViewable": {
                    return resourceProject == null || resourceProject.hasRealmPermission("project-resource-view");
                }
            }
            return false;
        }
        catch (Exception e) {
            log.debug((Object)("Error testing property " + property + ": " + e.getMessage()));
            return false;
        }
    }

    public static void firePropertyChange(String propName) {
        ActionUtils.evaluatePropertyState((String)("org.jkiss.dbeaver.core.datasource." + propName));
    }

    private static void updateEditorsDirtyFlag() {
        IEditorReference[] editors;
        IWorkbenchWindow workbenchWindow = UIUtils.findActiveWorkbenchWindow();
        if (workbenchWindow == null) {
            return;
        }
        IEditorReference[] iEditorReferenceArray = editors = workbenchWindow.getActivePage().getEditorReferences();
        int n = editors.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference ref = iEditorReferenceArray[n2];
            IEditorPart editor = ref.getEditor(false);
            if (editor instanceof IStatefulEditor) {
                UIUtils.asyncExec(() -> ((IStatefulEditor)((IStatefulEditor)editor)).updateDirtyFlag());
            }
            ++n2;
        }
    }

    private static class QMEventsHandler
    extends DefaultExecutionHandler {
        private QMEventsHandler() {
        }

        @NotNull
        public String getHandlerName() {
            return DataSourcePropertyTester.class.getName();
        }

        public synchronized void handleTransactionAutocommit(@NotNull DBCExecutionContext context, boolean autoCommit) {
            this.updateUI(() -> {
                DataSourcePropertyTester.firePropertyChange(DataSourcePropertyTester.PROP_TRANSACTIONAL);
                DataSourcePropertyTester.firePropertyChange(DataSourcePropertyTester.PROP_TRANSACTION_ACTIVE);
                ActionUtils.fireCommandRefresh((String[])new String[]{"org.jkiss.dbeaver.core.txn.autocommit"});
            });
        }

        public synchronized void handleTransactionCommit(@NotNull DBCExecutionContext context) {
            this.updateUI(() -> {
                DataSourcePropertyTester.firePropertyChange(DataSourcePropertyTester.PROP_TRANSACTION_ACTIVE);
                DataSourcePropertyTester.updateEditorsDirtyFlag();
            });
        }

        public synchronized void handleTransactionRollback(@NotNull DBCExecutionContext context, DBCSavepoint savepoint) {
            this.updateUI(() -> {
                DataSourcePropertyTester.firePropertyChange(DataSourcePropertyTester.PROP_TRANSACTION_ACTIVE);
                DataSourcePropertyTester.updateEditorsDirtyFlag();
            });
        }

        public synchronized void handleStatementExecuteBegin(@NotNull DBCStatement statement) {
            this.updateUI(() -> DataSourcePropertyTester.firePropertyChange(DataSourcePropertyTester.PROP_TRANSACTION_ACTIVE));
        }

        private void updateUI(Runnable runnable) {
            UIUtils.asyncExec((Runnable)runnable);
        }
    }

    public static class QMService
    implements IPluginService {
        private QMEventsHandler qmHandler;

        public void activateService() {
            this.qmHandler = new QMEventsHandler();
            QMUtils.registerHandler((QMExecutionHandler)this.qmHandler);
        }

        public void deactivateService() {
            QMUtils.unregisterHandler((QMExecutionHandler)this.qmHandler);
        }
    }
}

