/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.lsm.mapping;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.lsm.mapping.AbstractSyntaxNode;

public class ConcreteSyntaxNode
extends AbstractSyntaxNode {
    private List<AbstractSyntaxNode> children = null;
    private List<AbstractSyntaxNode> readonlyChildren = null;

    public ConcreteSyntaxNode() {
    }

    public ConcreteSyntaxNode(@NotNull String name) {
        super(name);
    }

    @NotNull
    public List<AbstractSyntaxNode> getChildren() {
        if (this.children == null) {
            return Collections.emptyList();
        }
        if (this.readonlyChildren == null) {
            this.readonlyChildren = Collections.unmodifiableList(this.children);
        }
        return this.readonlyChildren;
    }

    @NotNull
    public List<AbstractSyntaxNode> getChildren(@Nullable String name) {
        List<AbstractSyntaxNode> result;
        if (this.children == null) {
            result = Collections.emptyList();
        } else {
            result = new ArrayList<AbstractSyntaxNode>(this.children.size());
            for (AbstractSyntaxNode subnode : this.children) {
                if ((name != null || subnode.getName() != null) && (name == null || !name.equals(subnode.getName()))) continue;
                result.add(subnode);
            }
        }
        return result;
    }

    @NotNull
    public <T extends AbstractSyntaxNode> List<T> getChildren(@NotNull Class<T> subnodeType) {
        List result;
        if (this.children == null) {
            result = Collections.emptyList();
        } else {
            result = new ArrayList(this.children.size());
            for (AbstractSyntaxNode subnode : this.children) {
                if (!subnodeType.isAssignableFrom(subnode.getClass())) continue;
                AbstractSyntaxNode concreteSubnode = subnode;
                result.add(concreteSubnode);
            }
        }
        return result;
    }

    void addChild(@NotNull AbstractSyntaxNode node) {
        if (this.children == null) {
            this.children = new ArrayList<AbstractSyntaxNode>();
        }
        this.children.add(node);
    }
}

