/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui;

import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.ui.css.swt.internal.theme.BootstrapTheme3x;
import org.eclipse.e4.ui.css.swt.theme.IThemeEngine;
import org.eclipse.e4.ui.css.swt.theme.IThemeManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.eclipse.ui.themes.ITheme;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class UIStyles {
    private static final Log log = Log.getLog(UIStyles.class);
    private static final String THEME_HIGH_CONTRAST_ID = "org.eclipse.e4.ui.css.theme.high-contrast";
    static IPreferenceStore EDITORS_PREFERENCE_STORE;
    static IThemeEngine themeEngine;

    static {
        themeEngine = null;
    }

    public static synchronized IPreferenceStore getEditorsPreferenceStore() {
        if (EDITORS_PREFERENCE_STORE == null) {
            EDITORS_PREFERENCE_STORE = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.ui.editors");
        }
        return EDITORS_PREFERENCE_STORE;
    }

    public static boolean isDarkTheme() {
        return UIUtils.isDark(UIStyles.getDefaultTextBackground().getRGB()) || UIStyles.isDarkHighContrastTheme();
    }

    private static IThemeEngine getThemeEngine() {
        IThemeManager manager;
        ServiceReference ref;
        BundleContext context;
        Bundle bundle;
        if (themeEngine == null && (bundle = FrameworkUtil.getBundle(BootstrapTheme3x.class)) != null && (context = bundle.getBundleContext()) != null && (ref = context.getServiceReference(IThemeManager.class)) != null && (manager = (IThemeManager)context.getService(ref)) != null) {
            themeEngine = manager.getEngineForDisplay(Display.getDefault());
        }
        return themeEngine;
    }

    public static boolean isHighContrastTheme() {
        IThemeEngine themeEngine = UIStyles.getThemeEngine();
        org.eclipse.e4.ui.css.swt.theme.ITheme theme = null;
        if (themeEngine != null) {
            theme = themeEngine.getActiveTheme();
        } else {
            themeEngine = (IThemeEngine)PlatformUI.getWorkbench().getService(IThemeEngine.class);
            if (themeEngine != null) {
                theme = themeEngine.getActiveTheme();
            }
        }
        if (theme != null) {
            return theme.getId().equals(THEME_HIGH_CONTRAST_ID);
        }
        return false;
    }

    public static boolean isDarkHighContrastTheme() {
        return UIStyles.isHighContrastTheme() && UIUtils.isDark(UIStyles.getDefaultWidgetBackground().getRGB());
    }

    public static Color getDefaultWidgetBackground() {
        ITheme theme = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
        Color color = theme.getColorRegistry().get("org.eclipse.ui.workbench.INACTIVE_TAB_BG_START");
        if (color == null) {
            color = Display.getCurrent().getSystemColor(22);
        }
        return color;
    }

    public static Color getDefaultTextBackground() {
        return UIStyles.getDefaultTextColor("AbstractTextEditor.Color.Background", 25);
    }

    public static Color getDefaultTextForeground() {
        return UIStyles.getDefaultTextColor("AbstractTextEditor.Color.Foreground", 24);
    }

    public static Color getDefaultTextSelectionBackground() {
        return UIStyles.getDefaultTextColor("AbstractTextEditor.Color.SelectionBackground", 26);
    }

    public static Color getDefaultTextSelectionForeground() {
        return UIStyles.getDefaultTextColor("AbstractTextEditor.Color.SelectionForeground", 27);
    }

    public static Color getDefaultTextColor(String id, int defSWT) {
        IPreferenceStore preferenceStore = UIStyles.getEditorsPreferenceStore();
        String fgRGB = preferenceStore == null ? null : preferenceStore.getString(id);
        return CommonUtils.isEmpty((String)fgRGB) ? Display.getDefault().getSystemColor(defSWT) : UIUtils.getSharedColor(fgRGB);
    }

    public static Color getErrorTextForeground() {
        return UIStyles.getDefaultTextColor("AbstractTextEditor.Error.Color.Foreground", 3);
    }
}

