/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.driver;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.progress.WorkbenchJob;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.connection.DBPDataSourceProviderDescriptor;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.registry.DataSourceProviderDescriptor;
import org.jkiss.dbeaver.registry.DataSourceRegistry;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.registry.driver.DriverUtils;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.driver.DriverTabbedViewer;
import org.jkiss.dbeaver.ui.dialogs.driver.DriverTreeViewer;
import org.jkiss.dbeaver.ui.internal.UIConnectionMessages;
import org.jkiss.utils.CommonUtils;

public class DriverSelectViewer
extends Viewer {
    private static final int REFRESH_DELAY = 200;
    private static final String CLEAR_ICON = "org.jkiss.dbeaver.ui.dialogs.driver.DriverSelectViewer.CLEAR_ICON";
    private static final String DISABLED_CLEAR_ICON = "org.jkiss.dbeaver.ui.dialogs.driver.DriverSelectViewer.DCLEAR_ICON";
    private static final String PROP_SELECTOR_VIEW_TYPE = "driver.selector.view.mode";
    private static final String PROP_SELECTOR_ORDER_BY = "driver.selector.orderBy";
    private ToolItem switchItem;
    private final Object site;
    private final List<DBPDataSourceProviderDescriptor> providers;
    private final boolean expandRecent;
    private final SelectorViewType forceViewType;
    private final Composite composite;
    private StructuredViewer selectorViewer;
    private Text filterText;
    private Job refreshJob;
    private Composite selectorComposite;
    private final List<DBPDataSourceContainer> dataSources;
    private OrderBy orderBy;
    private Comparator<DBPDriver> driverComparator;

    private static SelectorViewType getCurrentSelectorViewType() {
        String viewTypeStr = DBWorkbench.getPlatform().getPreferenceStore().getString(PROP_SELECTOR_VIEW_TYPE);
        if (viewTypeStr == null) {
            return SelectorViewType.browser;
        }
        try {
            return SelectorViewType.valueOf(viewTypeStr);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return SelectorViewType.browser;
        }
    }

    private static void setCurrentSelectorViewType(SelectorViewType viewType) {
        DBWorkbench.getPlatform().getPreferenceStore().setValue(PROP_SELECTOR_VIEW_TYPE, viewType.name());
    }

    public DriverSelectViewer(Composite parent, Object site, List<DBPDataSourceProviderDescriptor> providers, boolean expandRecent) {
        this(parent, site, providers, expandRecent, null);
    }

    public DriverSelectViewer(Composite parent, Object site, List<DBPDataSourceProviderDescriptor> providers, boolean expandRecent, SelectorViewType forceViewType) {
        this.site = site;
        this.providers = providers;
        this.expandRecent = expandRecent;
        this.forceViewType = forceViewType;
        this.dataSources = DataSourceRegistry.getAllDataSources();
        OrderBy defOrderBy = DriverSelectViewer.getDefaultOrderBy();
        this.setOrderBy(defOrderBy);
        this.composite = new Composite(parent, 0);
        if (parent.getLayout() instanceof GridLayout) {
            this.composite.setLayoutData((Object)new GridData(1808));
        }
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.composite.setLayout((Layout)layout);
        this.createFilterControl(this.composite);
        this.selectorComposite = UIUtils.createComposite((Composite)this.composite, (int)1);
        this.selectorComposite.setLayoutData((Object)new GridData(1808));
        this.selectorComposite.setForeground(this.filterText.getForeground());
        this.selectorComposite.setBackground(this.filterText.getBackground());
        this.createSelectorControl();
        this.filterText.addTraverseListener(e -> this.selectorViewer.getControl().traverse(e.detail, (KeyEvent)e));
        this.refreshJob = this.createRefreshJob();
    }

    public static OrderBy getDefaultOrderBy() {
        return (OrderBy)CommonUtils.valueOf(OrderBy.class, (String)DBWorkbench.getPlatform().getPreferenceStore().getString(PROP_SELECTOR_ORDER_BY), (Enum)OrderBy.score);
    }

    public OrderBy getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(OrderBy orderBy) {
        this.orderBy = orderBy;
        switch (orderBy) {
            case name: {
                this.driverComparator = new DriverUtils.DriverNameComparator();
                break;
            }
            case score: {
                this.driverComparator = new DriverUtils.DriverScoreComparator(this.dataSources);
            }
        }
        if (this.selectorViewer instanceof DriverTabbedViewer) {
            ((DriverTabbedViewer)this.selectorViewer).setListComparator(this.driverComparator);
        }
        DBWorkbench.getPlatform().getPreferenceStore().setValue(PROP_SELECTOR_ORDER_BY, orderBy.name());
    }

    private Control getSelectorControl() {
        return this.selectorViewer.getControl();
    }

    private void createFilterControl(Composite parent) {
        Composite filterGroup = UIUtils.createComposite((Composite)parent, (int)1);
        filterGroup.setLayoutData((Object)new GridData(768));
        this.createExtraFilterControlsBefore(filterGroup);
        Composite filterComposite = new Composite(filterGroup, 2048);
        filterComposite.setLayoutData((Object)new GridData(768));
        GridLayout filterLayout = new GridLayout(2, false);
        filterLayout.marginHeight = 0;
        filterLayout.marginWidth = 0;
        filterComposite.setLayout((Layout)filterLayout);
        filterComposite.setFont(this.composite.getFont());
        this.filterText = new Text(filterComposite, 4);
        this.filterText.setMessage(UIConnectionMessages.dialog_connection_driver_treecontrol_initialText);
        this.filterText.setLayoutData((Object)new GridData(768));
        this.filterText.addModifyListener(e -> this.textChanged());
        this.filterText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.keyCode == 0x1000002 || keyEvent.keyCode == 13) {
                    DriverSelectViewer.this.getSelectorControl().setFocus();
                }
            }
        });
        filterComposite.setBackground(this.filterText.getBackground());
        filterComposite.setLayoutData((Object)new GridData(4, 1, true, false));
        this.createFilterToolbar(filterComposite);
        this.createExtraFilterControlsAfter(filterGroup);
        UIUtils.asyncExec(() -> filterComposite.layout(true, true));
    }

    protected void createExtraFilterControlsBefore(Composite filterGroup) {
    }

    protected void createExtraFilterControlsAfter(Composite filterGroup) {
    }

    private void createFilterToolbar(Composite parent) {
        ToolBar switcherToolbar = new ToolBar(parent, 131328);
        ToolItem clearItem = new ToolItem(switcherToolbar, 8);
        clearItem.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.ERASE));
        clearItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DriverSelectViewer.this.clearText();
                DriverSelectViewer.this.filterText.setFocus();
            }
        });
        if (this.forceViewType == null) {
            this.switchItem = new ToolItem(switcherToolbar, 36);
            this.switchItem.setText("Switch view");
            this.switchItem.setWidth(UIUtils.getFontHeight((Control)switcherToolbar) * 15);
            this.switchItem.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.TREE_SCHEMA));
            this.switchItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DriverSelectViewer.this.switchSelectorControl();
                }
            });
        }
        switcherToolbar.setBackground(this.filterText.getBackground());
    }

    private void clearText() {
        this.filterText.setText("");
        this.textChanged();
    }

    @NotNull
    private String getFilterString() {
        return this.filterText != null ? this.filterText.getText() : "";
    }

    private void textChanged() {
        this.refreshJob.cancel();
        this.refreshJob.schedule(200L);
    }

    private void createSelectorControl() {
        this.selectorComposite.setRedraw(false);
        try {
            if (this.forceViewType == SelectorViewType.tree || this.forceViewType == null && DriverSelectViewer.getCurrentSelectorViewType() == SelectorViewType.tree) {
                if (this.forceViewType == null) {
                    this.switchItem.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.TREE_SCHEMA));
                    this.switchItem.setText(UIConnectionMessages.viewer_selector_control_text_gallery);
                    this.switchItem.setSelection(true);
                }
                this.selectorViewer = new DriverTreeViewer(this.selectorComposite, 2816);
                this.selectorViewer.getControl().setLayoutData((Object)new GridData(1808));
                UIUtils.asyncExec(() -> {
                    if (this.selectorViewer instanceof DriverTreeViewer) {
                        ((DriverTreeViewer)this.selectorViewer).initDrivers(this.providers, this.expandRecent);
                    }
                });
            } else {
                if (this.forceViewType == null) {
                    this.switchItem.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.TREE_TABLE));
                    this.switchItem.setText(UIConnectionMessages.viewer_selector_control_text_classic);
                    this.switchItem.setSelection(false);
                }
                this.selectorViewer = new DriverTabbedViewer(this.selectorComposite, 0, this.dataSources, this.driverComparator);
                this.selectorViewer.getControl().setLayoutData((Object)new GridData(1808));
            }
            this.selectorViewer.addSelectionChangedListener(event -> {
                if (this.site instanceof ISelectionChangedListener) {
                    ((ISelectionChangedListener)this.site).selectionChanged(event);
                }
            });
            this.selectorViewer.addDoubleClickListener(event -> {
                if (this.site instanceof IDoubleClickListener) {
                    ((IDoubleClickListener)this.site).doubleClick(event);
                }
            });
        }
        finally {
            this.selectorComposite.setRedraw(true);
        }
    }

    private Object[] collectDrivers(List<DataSourceProviderDescriptor> provs) {
        ArrayList drivers = new ArrayList();
        if (provs != null) {
            for (DataSourceProviderDescriptor provider : provs) {
                drivers.addAll(provider.getEnabledDrivers());
            }
        }
        drivers.sort((o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName()));
        return drivers.toArray(new Object[0]);
    }

    private void switchSelectorControl() {
        this.selectorComposite.setRedraw(false);
        try {
            SelectorViewType viewType = DriverSelectViewer.getCurrentSelectorViewType();
            viewType = viewType == SelectorViewType.tree ? SelectorViewType.browser : SelectorViewType.tree;
            DriverSelectViewer.setCurrentSelectorViewType(viewType);
            ISelection curSelection = this.selectorViewer.getSelection();
            this.selectorViewer.getControl().dispose();
            this.createSelectorControl();
            if (curSelection instanceof StructuredSelection && !curSelection.isEmpty()) {
                Object element = ((StructuredSelection)curSelection).getFirstElement();
                UIUtils.asyncExec(() -> this.selectorViewer.setSelection((ISelection)new StructuredSelection(element), true));
            }
            this.selectorComposite.layout(true, true);
        }
        finally {
            this.selectorComposite.setRedraw(true);
        }
        if (!CommonUtils.isEmpty((String)this.filterText.getText())) {
            this.textChanged();
        }
    }

    private WorkbenchJob createRefreshJob() {
        return new WorkbenchJob("Refresh driver filter"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (DriverSelectViewer.this.getControl().isDisposed()) {
                    return Status.CANCEL_STATUS;
                }
                DriverSelectViewer.this.selectorViewer.getControl().setRedraw(false);
                try {
                    String text = DriverSelectViewer.this.getFilterString();
                    if (CommonUtils.isEmpty((String)text)) {
                        DriverSelectViewer.this.selectorViewer.setFilters(new ViewerFilter[0]);
                        IStatus iStatus = Status.OK_STATUS;
                        return iStatus;
                    }
                    DriverFilter driverFilter = new DriverFilter();
                    driverFilter.setPattern(text);
                    DriverSelectViewer.this.selectorViewer.setFilters(new ViewerFilter[]{driverFilter});
                    if (DriverSelectViewer.this.selectorViewer instanceof AbstractTreeViewer) {
                        ((AbstractTreeViewer)DriverSelectViewer.this.selectorViewer).expandAll();
                    }
                }
                finally {
                    DriverSelectViewer.this.selectorViewer.getControl().setRedraw(true);
                }
                return Status.OK_STATUS;
            }
        };
    }

    public StructuredViewer getSelectorViewer() {
        return this.selectorViewer;
    }

    public DriverTabbedViewer getTabbedViewer() {
        return (DriverTabbedViewer)this.selectorViewer;
    }

    public Control getControl() {
        return this.composite;
    }

    public Object getInput() {
        return this.selectorViewer.getInput();
    }

    public ISelection getSelection() {
        return this.selectorViewer.getSelection();
    }

    public void refresh() {
        this.selectorViewer.refresh();
    }

    public void refresh(DBPDriver driver) {
        this.selectorViewer.refresh((Object)driver);
    }

    public void setInput(Object input) {
        this.selectorViewer.setInput(input);
    }

    public void setSelection(ISelection selection, boolean reveal) {
        this.selectorViewer.setSelection(selection, reveal);
    }

    private static class DriverFilter
    extends PatternFilter {
        DriverFilter() {
            this.setIncludeLeadingWildcard(true);
        }

        public boolean isElementVisible(Viewer viewer, Object element) {
            if (viewer instanceof AbstractTreeViewer) {
                Object parent = ((ITreeContentProvider)((AbstractTreeViewer)viewer).getContentProvider()).getParent(element);
                if (parent != null && this.isLeafMatch(viewer, parent)) {
                    return true;
                }
                return this.isParentMatch(viewer, element) || this.isLeafMatch(viewer, element);
            }
            return this.isLeafMatch(viewer, element);
        }

        protected boolean isLeafMatch(Viewer viewer, Object element) {
            if (element instanceof DriverDescriptor) {
                return this.wordMatches(((DriverDescriptor)element).getName()) || this.wordMatches(((DriverDescriptor)element).getDescription()) || this.wordMatches(((DriverDescriptor)element).getCategory());
            }
            return super.isLeafMatch(viewer, element);
        }
    }

    public static enum OrderBy {
        name(UIConnectionMessages.dialog_driver_select_viewer_order_by_name_label, UIConnectionMessages.dialog_driver_select_viewer_order_by_name_description),
        score(UIConnectionMessages.dialog_driver_select_viewer_order_by_score_label, UIConnectionMessages.dialog_driver_select_viewer_order_by_score_description);

        private final String label;
        private final String description;

        private OrderBy(String label, String description) {
            this.label = label;
            this.description = description;
        }

        public String getLabel() {
            return this.label;
        }

        public String getDescription() {
            return this.description;
        }
    }

    public static enum SelectorViewType {
        tree,
        browser;

    }
}

