/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.dpi.server;

import com.google.gson.Gson;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.dpi.model.DPIContext;
import org.jkiss.dbeaver.dpi.model.DPIController;
import org.jkiss.dbeaver.dpi.model.DPISession;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.LoggingProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.rest.RestServer;

public class DPIControllerImpl
implements DPIController {
    private static final Log log = Log.getLog(DPIControllerImpl.class);
    private final DPIContext context;
    private final Map<String, DPISession> sessions = new LinkedHashMap<String, DPISession>();
    private RestServer<?> server;

    public DPIControllerImpl(DPIContext context) {
        this.context = context;
    }

    public String ping() throws DBException {
        return "pong";
    }

    public DPISession openSession(String projectId) {
        DPISession session = new DPISession(UUID.randomUUID().toString());
        this.sessions.put(session.getSessionId(), session);
        return session;
    }

    @NotNull
    public synchronized DBPDataSource openDataSource(@NotNull String session, @NotNull String projectId, @NotNull String container, @Nullable Map<String, String> credentials) throws DBException {
        this.getSession(session);
        DBPProject project = DBWorkbench.getPlatform().getWorkspace().getProjectById(projectId);
        if (project == null) {
            throw new DBException("Project '" + projectId + "' not found");
        }
        DBPDataSourceContainer dataSourceContainer = project.getDataSourceRegistry().getDataSource(container);
        if (dataSourceContainer == null) {
            throw new DBException("Data source '" + container + "' not found");
        }
        LoggingProgressMonitor monitor = new LoggingProgressMonitor(log);
        dataSourceContainer.connect((DBRProgressMonitor)monitor, true, false);
        DBPDataSource dataSource = dataSourceContainer.getDataSource();
        return dataSource;
    }

    public void closeSession(@NotNull String sessionId) throws DBException {
        this.getSession(sessionId);
        this.sessions.remove(sessionId);
        if (this.sessions.isEmpty() && this.server != null) {
            new AbstractJob("Stop detached server"){

                protected IStatus run(DBRProgressMonitor monitor) {
                    DPIControllerImpl.this.server.stop(1);
                    DPIControllerImpl.this.server = null;
                    return Status.OK_STATUS;
                }
            }.schedule(200L);
        }
    }

    public synchronized Object callMethod(@NotNull String objectId, @NotNull String method, @Nullable Object[] args) throws DBException {
        Object object = this.context.getObject(objectId);
        if (object == null) {
            throw new DBException("DPI object '" + objectId + "' not found");
        }
        Method[] methodArray = object.getClass().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method objMethod = methodArray[n2];
            if (objMethod.getName().equals(method)) {
                Object[] argTypes = objMethod.getParameterTypes();
                if (args != null && argTypes.length > 0 && argTypes.length != args.length && argTypes[0] == DBRProgressMonitor.class) {
                    Object[] modifiedArgs = new Object[args.length + 1];
                    modifiedArgs[0] = this.context.getProgressMonitor();
                    System.arraycopy(args, 0, modifiedArgs, 1, args.length);
                    args = modifiedArgs;
                }
                if (ArrayUtils.isEmpty((Object[])args) && ArrayUtils.isEmpty((Object[])argTypes) || args != null && argTypes.length == args.length) {
                    return this.invokeObjectMethod(object, objMethod, args);
                }
            }
            ++n2;
        }
        throw new DBException("Method '" + method + "' not found in DPI object '" + objectId + "'");
    }

    private Object invokeObjectMethod(Object object, Method method, Object[] args) throws DBException {
        try {
            log.debug((Object)("DPI Server: invoke DPI method " + method + " on " + object.getClass()));
            if (args == null) {
                return method.invoke(object, new Object[0]);
            }
            Class<?>[] parameterTypes = method.getParameterTypes();
            Object[] realArgs = new Object[args.length];
            Gson gson = this.context.getGson();
            int i = 0;
            while (i < parameterTypes.length) {
                realArgs[i] = args[i] instanceof String && !CharSequence.class.isAssignableFrom(parameterTypes[i]) ? gson.fromJson((String)args[i], parameterTypes[i]) : (args[i] instanceof Map && !Map.class.isAssignableFrom(parameterTypes[i]) ? gson.fromJson(gson.toJsonTree(args[i], Map.class), parameterTypes[i]) : args[i]);
                ++i;
            }
            return method.invoke(object, realArgs);
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException) {
                e = ((InvocationTargetException)e).getTargetException();
            }
            throw new DBException("Error invoking DPI method", e);
        }
    }

    private DPISession getSession(@NotNull String sessionId) throws DBException {
        DPISession session = this.sessions.get(sessionId);
        if (session == null) {
            throw new DBException("Session '" + sessionId + "' not found");
        }
        return session;
    }

    public void close() {
    }

    public void setServer(RestServer<?> server) {
        this.server = server;
    }

    public RestServer<?> getServer() {
        return this.server;
    }
}

