/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.app.standalone.actions;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.jkiss.dbeaver.ui.dialogs.DialogUtils;

public class OpenLocalFileActionExt
extends AbstractHandler {
    private IWorkbenchWindow window;
    private String filterPath;

    public OpenLocalFileActionExt() {
        this.setEnabled(true);
        this.filterPath = DialogUtils.getCurDialogFolder();
    }

    public void dispose() {
        this.window = null;
        this.filterPath = null;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell activeShell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        FileDialog dialog = new FileDialog(activeShell, 0x10001002);
        dialog.setText(IDEWorkbenchMessages.OpenLocalFileAction_title);
        dialog.setFilterPath(this.filterPath);
        dialog.open();
        String[] names = dialog.getFileNames();
        if (names != null) {
            this.filterPath = dialog.getFilterPath();
            DialogUtils.setCurDialogFolder((String)this.filterPath);
            int numberOfFilesNotFound = 0;
            StringBuilder notFound = new StringBuilder();
            String[] stringArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                IFileStore fileStore = EFS.getLocalFileSystem().getStore((IPath)new Path(this.filterPath));
                IFileInfo fetchInfo = (fileStore = fileStore.getChild(name)).fetchInfo();
                if (!fetchInfo.isDirectory() && fetchInfo.exists()) {
                    IWorkbenchPage page = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage();
                    try {
                        IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
                    }
                    catch (PartInitException e) {
                        String msg = NLS.bind((String)IDEWorkbenchMessages.OpenLocalFileAction_message_errorOnOpen, (Object)fileStore.getName());
                        IDEWorkbenchPlugin.log((String)msg, (IStatus)e.getStatus());
                        MessageDialog.open((int)1, (Shell)activeShell, (String)IDEWorkbenchMessages.OpenLocalFileAction_title, (String)msg, (int)0x10000000);
                    }
                } else {
                    if (++numberOfFilesNotFound > 1) {
                        notFound.append('\n');
                    }
                    notFound.append(fileStore.getName());
                }
                ++n2;
            }
            if (numberOfFilesNotFound > 0) {
                String msgFmt = numberOfFilesNotFound == 1 ? IDEWorkbenchMessages.OpenLocalFileAction_message_fileNotFound : IDEWorkbenchMessages.OpenLocalFileAction_message_filesNotFound;
                String msg = NLS.bind((String)msgFmt, (Object)notFound.toString());
                MessageDialog.open((int)1, (Shell)activeShell, (String)IDEWorkbenchMessages.OpenLocalFileAction_title, (String)msg, (int)0x10000000);
            }
        }
        return null;
    }
}

