/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc.exec;

import java.lang.reflect.Field;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Types;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataTypeProvider;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCAttributeMetaData;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.exec.JDBCResultSetMetaDataImpl;
import org.jkiss.dbeaver.model.impl.jdbc.exec.JDBCTableMetaData;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObjectJDBC;
import org.jkiss.utils.CommonUtils;

public class JDBCColumnMetaData
implements DBCAttributeMetaData,
DBSTypedObjectJDBC {
    private static final Log log = Log.getLog(JDBCColumnMetaData.class);
    public static final String PROP_CATEGORY_COLUMN = "Column";
    private final int ordinalPosition;
    private boolean notNull;
    private long displaySize;
    private final String label;
    private final String name;
    private int precision;
    private int scale;
    private final String tableName;
    private int typeID;
    private String typeName;
    private boolean readOnly;
    private boolean writable;
    private boolean sequence;
    private DBPDataKind dataKind;
    private JDBCTableMetaData tableMetaData;
    private DBCExecutionSource source;
    private String catalogName;
    private String schemaName;

    public JDBCColumnMetaData(JDBCResultSetMetaDataImpl resultSetMeta, int ordinalPosition) throws SQLException {
        this((DBPDataSource)resultSetMeta.getResultSet().getSession().getDataSource(), resultSetMeta, ordinalPosition);
        JDBCStatement rsSource = resultSetMeta.getResultSet().getSourceStatement();
        this.source = rsSource != null ? rsSource.getStatementSource() : null;
        this.tableMetaData = !CommonUtils.isEmpty((String)this.tableName) ? resultSetMeta.getTableMetaData(this.catalogName, this.schemaName, this.tableName) : null;
        if (this.tableMetaData != null) {
            this.tableMetaData.addAttribute(this);
        }
    }

    public JDBCColumnMetaData(DBPDataSource dataSource, ResultSetMetaData resultSetMeta, int ordinalPosition) throws SQLException {
        this.ordinalPosition = ordinalPosition;
        this.label = CommonUtils.notEmpty((String)resultSetMeta.getColumnLabel(ordinalPosition + 1));
        this.name = CommonUtils.notEmpty((String)resultSetMeta.getColumnName(ordinalPosition + 1));
        this.readOnly = false;
        try {
            this.writable = resultSetMeta.isWritable(ordinalPosition + 1);
        }
        catch (Throwable e) {
            log.debug((Object)("Can't get column writable flag: " + e.getMessage()));
        }
        String fetchedTableName = null;
        try {
            fetchedTableName = resultSetMeta.getTableName(ordinalPosition + 1);
        }
        catch (Throwable e) {
            log.debug((Object)("Can't get column table name: " + e.getMessage()));
        }
        try {
            this.catalogName = resultSetMeta.getCatalogName(ordinalPosition + 1);
        }
        catch (Throwable e) {
            log.debug((Object)("Can't get column catalog name: " + e.getMessage()));
        }
        try {
            this.schemaName = resultSetMeta.getSchemaName(ordinalPosition + 1);
        }
        catch (Throwable e) {
            log.debug((Object)("Can't get column schema name: " + e.getMessage()));
        }
        if (!CommonUtils.isEmpty((String)fetchedTableName) && CommonUtils.isEmpty((String)this.catalogName) && CommonUtils.isEmpty((String)this.schemaName)) {
            SQLDialect sqlDialect = dataSource.getSQLDialect();
            if (!DBUtils.isQuotedIdentifier((DBPDataSource)dataSource, (String)fetchedTableName)) {
                char structSeparator;
                int schemaDivPos;
                String catalogSeparator = sqlDialect.getCatalogSeparator();
                int catDivPos = fetchedTableName.indexOf(catalogSeparator);
                if (catDivPos != -1 && (sqlDialect.getCatalogUsage() & 1) != 0) {
                    this.catalogName = fetchedTableName.substring(0, catDivPos);
                    fetchedTableName = fetchedTableName.substring(catDivPos + catalogSeparator.length());
                }
                if ((schemaDivPos = fetchedTableName.indexOf(structSeparator = sqlDialect.getStructSeparator())) != -1 && (sqlDialect.getSchemaUsage() & 1) != 0) {
                    this.schemaName = fetchedTableName.substring(0, schemaDivPos);
                    fetchedTableName = fetchedTableName.substring(schemaDivPos + 1);
                }
            }
        }
        try {
            this.notNull = resultSetMeta.isNullable(ordinalPosition + 1) == 0;
        }
        catch (Throwable e) {
            this.notNull = false;
            log.debug((Object)("Can't get column nullability: " + e.getMessage()));
        }
        try {
            this.displaySize = resultSetMeta.getColumnDisplaySize(ordinalPosition + 1);
        }
        catch (Throwable throwable) {
            this.displaySize = 0L;
        }
        try {
            this.typeName = resultSetMeta.getColumnTypeName(ordinalPosition + 1);
        }
        catch (Throwable e) {
            log.debug((Object)("Can't get column type name: " + e.getMessage()));
            this.typeName = "unknown";
        }
        try {
            DBSDataType dataType;
            int typeID = resultSetMeta.getColumnType(ordinalPosition + 1);
            DBPDataKind dataKind = null;
            if (dataSource instanceof DBPDataTypeProvider && (dataType = ((DBPDataTypeProvider)dataSource).getLocalDataType(this.typeName)) != null) {
                typeID = dataType.getTypeID();
                dataKind = dataType.getDataKind();
            }
            if (dataKind == null) {
                dataKind = JDBCUtils.resolveDataKind(dataSource, this.typeName, typeID);
            }
            this.typeID = typeID;
            this.dataKind = dataKind;
        }
        catch (Throwable e) {
            log.debug((Object)("Can't get column type ID: " + e.getMessage()));
            this.typeID = -1;
            this.dataKind = DBPDataKind.UNKNOWN;
        }
        try {
            this.sequence = resultSetMeta.isAutoIncrement(ordinalPosition + 1);
        }
        catch (Throwable e) {
            this.sequence = false;
            log.debug((Object)("Can't get column auto increment: " + e.getMessage()));
        }
        try {
            this.precision = resultSetMeta.getPrecision(ordinalPosition + 1);
        }
        catch (Throwable throwable) {
            this.precision = 0;
        }
        try {
            this.scale = resultSetMeta.getScale(ordinalPosition + 1);
        }
        catch (Throwable throwable) {
            this.scale = 0;
        }
        this.tableName = fetchedTableName;
    }

    public DBCExecutionSource getSource() {
        return this.source;
    }

    @Property(viewable=true, category="Column", order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Property(viewable=true, category="Column", order=2)
    @NotNull
    public String getLabel() {
        return this.label;
    }

    @Property(viewable=true, category="Column", order=3)
    public int getOrdinalPosition() {
        return this.ordinalPosition;
    }

    @Property(viewable=true, category="Column", order=5)
    public String getCatalogName() {
        return this.catalogName;
    }

    @Property(viewable=true, category="Column", order=6)
    public String getSchemaName() {
        return this.schemaName;
    }

    @Property(viewable=true, category="Column", order=7)
    @Nullable
    public String getEntityName() {
        return this.tableName;
    }

    @Property(viewable=true, category="Column", order=30)
    public boolean isRequired() {
        return this.notNull;
    }

    @Property(viewable=true, category="Column", order=30)
    public boolean isAutoGenerated() {
        return this.sequence;
    }

    @Property(viewable=true, category="Column", order=20)
    public long getMaxLength() {
        return this.displaySize;
    }

    public long getTypeModifiers() {
        return 0L;
    }

    @Property(viewable=true, category="Column", order=21)
    public Integer getPrecision() {
        return this.precision;
    }

    @Property(viewable=true, category="Column", order=22)
    public Integer getScale() {
        return this.scale;
    }

    public int getTypeID() {
        return this.typeID;
    }

    @Property(viewable=true, category="Column", order=23)
    @NotNull
    public String getJdbcType() {
        int typeID = this.getTypeID();
        try {
            Field[] fieldArray = Types.class.getFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Integer value;
                Field field = fieldArray[n2];
                if ((field.getModifiers() & 8) != 0 && field.getType() == Integer.TYPE && (value = (Integer)field.get(null)) != null && typeID == value) {
                    return field.getName();
                }
                ++n2;
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        return String.valueOf(typeID);
    }

    public DBPDataKind getDataKind() {
        return this.dataKind;
    }

    @Property(viewable=true, category="Column", order=4)
    public String getTypeName() {
        return this.typeName;
    }

    public String getFullTypeName() {
        return DBUtils.getFullTypeName((DBSTypedObject)this);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isWritable() {
        return this.writable;
    }

    @Nullable
    public JDBCTableMetaData getEntityMetaData() {
        return this.tableMetaData;
    }

    public String toString() {
        StringBuilder db = new StringBuilder();
        if (!CommonUtils.isEmpty((String)this.tableName)) {
            db.append(this.tableName).append('.');
        }
        if (!CommonUtils.isEmpty((String)this.name)) {
            db.append(this.name);
        }
        if (!CommonUtils.isEmpty((String)this.label)) {
            db.append(" as ").append(this.label);
        }
        return db.toString();
    }
}

