/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc.data.handlers;

import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBConstants;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDObject;
import org.jkiss.dbeaver.model.data.DBDValue;
import org.jkiss.dbeaver.model.data.DBDValueCloneable;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.data.JDBCCursor;
import org.jkiss.dbeaver.model.impl.jdbc.data.JDBCRowId;
import org.jkiss.dbeaver.model.impl.jdbc.data.handlers.JDBCAbstractValueHandler;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class JDBCObjectValueHandler
extends JDBCAbstractValueHandler {
    private static final Log log = Log.getLog(JDBCObjectValueHandler.class);
    public static final JDBCObjectValueHandler INSTANCE = new JDBCObjectValueHandler();

    @Override
    protected Object fetchColumnValue(DBCSession session, JDBCResultSet resultSet, DBSTypedObject type, int index) throws DBCException, SQLException {
        Object value = resultSet.getObject(index);
        if (value instanceof ResultSet) {
            value = new JDBCCursor((JDBCSession)session, (ResultSet)value, type.getTypeName());
        } else if (value instanceof RowId) {
            value = new JDBCRowId((RowId)value);
        }
        return value;
    }

    @Override
    protected void bindParameter(JDBCSession session, JDBCPreparedStatement statement, DBSTypedObject paramType, int paramIndex, Object value) throws DBCException, SQLException {
        if (value == null) {
            statement.setNull(paramIndex, paramType.getTypeID());
        } else if (value instanceof JDBCRowId) {
            statement.setRowId(paramIndex, ((JDBCRowId)value).getValue());
        } else {
            try {
                statement.setObject(paramIndex, value, paramType.getTypeID());
            }
            catch (SQLException sQLException) {
                statement.setObject(paramIndex, value);
            }
        }
    }

    @NotNull
    public Class<?> getValueObjectType(@NotNull DBSTypedObject attribute) {
        return Object.class;
    }

    public Object getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, Object object, boolean copy, boolean validateValue) throws DBCException {
        if (copy && object != null && object instanceof DBDObject) {
            if (object instanceof DBDValueCloneable) {
                return ((DBDValueCloneable)object).cloneValue(session.getProgressMonitor());
            }
            throw new DBCException("Can't copy object value " + object);
        }
        return object;
    }

    @NotNull
    public String getValueDisplayString(@NotNull DBSTypedObject column, Object value, @NotNull DBDDisplayFormat format) {
        if (value instanceof DBDValue) {
            return value.toString();
        }
        if (format == DBDDisplayFormat.NATIVE) {
            String typeName = column.getTypeName();
            if (value instanceof String && !((String)value).startsWith("'") && (typeName.equals("UUID") || typeName.equals(DBConstants.TYPE_NAME_UUID2))) {
                return "'" + value + "'";
            }
        }
        return DBValueFormatting.getDefaultValueDisplayString((Object)value, (DBDDisplayFormat)format);
    }
}

