/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc.data;

import java.io.IOException;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.data.DBDContentStorage;
import org.jkiss.dbeaver.model.data.DBDValueCloneable;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCTransactionManager;
import org.jkiss.dbeaver.model.impl.jdbc.data.JDBCContentAbstract;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public abstract class JDBCContentLOB
extends JDBCContentAbstract
implements DBDContent {
    private static final String ERROR_MESSAGE_PARAM_IS_SHOWN = "lob-reading-error-message-is-shown";
    private DBDContentStorage originalStorage;
    protected DBDContentStorage storage;

    protected JDBCContentLOB(DBCExecutionContext dataSource) {
        super(dataSource);
    }

    public long getContentLength() throws DBCException {
        if (this.storage != null) {
            try {
                return this.storage.getContentLength();
            }
            catch (IOException e) {
                throw new DBCException("Error reading content length", (Throwable)e);
            }
        }
        return this.getLOBLength();
    }

    protected abstract long getLOBLength() throws DBCException;

    public boolean updateContents(DBRProgressMonitor monitor, DBDContentStorage storage) {
        if (this.storage != null) {
            if (this.originalStorage != null && this.originalStorage != this.storage) {
                this.originalStorage.release();
            }
            this.originalStorage = this.storage;
        }
        this.storage = storage;
        this.modified = true;
        return true;
    }

    public void release() {
        if (this.storage != null) {
            this.storage.release();
            this.storage = null;
        }
        if (this.originalStorage != null) {
            this.originalStorage.release();
            this.originalStorage = null;
        }
    }

    public void resetContents() {
        if (this.originalStorage != null) {
            if (this.storage != null) {
                this.storage.release();
            }
            this.storage = this.originalStorage;
            this.modified = false;
        }
    }

    public DBDValueCloneable cloneValue(DBRProgressMonitor monitor) throws DBCException {
        JDBCContentLOB copy = this.createNewContent();
        DBDContentStorage storage = this.getContents(monitor);
        if (storage != null) {
            try {
                copy.updateContents(monitor, storage.cloneStorage(monitor));
            }
            catch (IOException e) {
                throw new DBCException("IO error while clone content", (Throwable)e);
            }
        }
        return copy;
    }

    protected abstract JDBCContentLOB createNewContent();

    void handleContentReadingException(DBCException e) throws DBCException {
        DBCTransactionManager transactionManager = DBUtils.getTransactionManager((DBCExecutionContext)this.executionContext);
        boolean errorMessageIsShown = CommonUtils.toBoolean((Object)this.executionContext.getContextAttribute(ERROR_MESSAGE_PARAM_IS_SHOWN));
        if (!errorMessageIsShown && transactionManager != null && transactionManager.isAutoCommit()) {
            DBWorkbench.getPlatformUI().showWarningMessageBox(ModelMessages.jdbc_content_view_error_message_title, ModelMessages.jdbc_content_view_error_message_hint);
            this.executionContext.setContextAttribute(ERROR_MESSAGE_PARAM_IS_SHOWN, (Object)Boolean.TRUE);
        }
        throw new DBCException(e.getMessage(), (Throwable)e);
    }
}

