/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.utils;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.function.Supplier;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;

public class BeanUtils {
    public static final Short DEFAULT_SHORT = 0;
    public static final Integer DEFAULT_INTEGER = 0;
    public static final Long DEFAULT_LONG = 0L;
    public static final Float DEFAULT_FLOAT = Float.valueOf(0.0f);
    public static final Double DEFAULT_DOUBLE = 0.0;
    public static final Byte DEFAULT_BYTE = 0;
    public static final Character DEFAULT_CHAR = Character.valueOf('\u0000');

    public static boolean isGetterName(String name) {
        return name.startsWith("get") || name.startsWith("is") || name.startsWith("has");
    }

    public static String getPropertyNameFromGetter(String getterName) {
        if (getterName.startsWith("get")) {
            return String.valueOf(Character.toLowerCase(getterName.charAt(3))) + getterName.substring(4);
        }
        if (getterName.startsWith("is")) {
            return String.valueOf(Character.toLowerCase(getterName.charAt(2))) + getterName.substring(3);
        }
        if (getterName.startsWith("has")) {
            return String.valueOf(Character.toLowerCase(getterName.charAt(3))) + getterName.substring(4);
        }
        return null;
    }

    public static String getSetterName(String getterName) {
        if (getterName.startsWith("get")) {
            return "set" + getterName.substring(3);
        }
        if (getterName.startsWith("is")) {
            return "set" + getterName.substring(2);
        }
        if (getterName.startsWith("has")) {
            return "set" + getterName.substring(3);
        }
        return null;
    }

    public static Method getSetMethod(Class<?> cl, String propertyName) {
        Method method = BeanUtils.getSetMethod(cl, propertyName, false);
        if (method != null) {
            return method;
        }
        return BeanUtils.getSetMethod(cl, propertyName, true);
    }

    public static Method getSetMethod(Class<?> cl, String propertyName, boolean ignoreCase) {
        String setName = "set" + BeanUtils.propertyNameToMethodName(propertyName);
        return BeanUtils.getSetMethod(cl.getMethods(), setName, ignoreCase);
    }

    public static Method getGetMethod(Class<?> cl, String propertyName) {
        Method method = BeanUtils.getGetMethod(cl, propertyName, false);
        return method != null ? method : BeanUtils.getGetMethod(cl, propertyName, true);
    }

    public static Method getGetMethod(Class<?> cl, String propertyName, boolean ignoreCase) {
        String methodName = BeanUtils.propertyNameToMethodName(propertyName);
        return BeanUtils.getGetMethod(cl.getMethods(), "get" + methodName, "is" + methodName, ignoreCase);
    }

    public static String propertyNameToMethodName(String propertyName) {
        char ch = propertyName.charAt(0);
        if (Character.isLowerCase(ch)) {
            propertyName = String.valueOf(Character.toUpperCase(ch)) + propertyName.substring(1);
        }
        return propertyName;
    }

    public static String methodNameToPropertyName(String methodName) {
        if (methodName.startsWith("get")) {
            methodName = methodName.substring(3);
        } else if (methodName.startsWith("set")) {
            methodName = methodName.substring(3);
        } else if (methodName.startsWith("is")) {
            methodName = methodName.substring(2);
        }
        if (methodName.length() == 0) {
            return null;
        }
        char ch = methodName.charAt(0);
        if (Character.isUpperCase(ch) && (methodName.length() == 1 || !Character.isUpperCase(methodName.charAt(1)))) {
            methodName = String.valueOf(Character.toLowerCase(ch)) + methodName.substring(1);
        }
        return methodName;
    }

    public static boolean isArrayType(Type type) {
        return type instanceof Class && ((Class)type).isArray();
    }

    public static boolean isCollectionType(Type type) {
        if (type instanceof Class && Collection.class.isAssignableFrom((Class)type)) {
            return true;
        }
        return BeanUtils.isArrayType(type);
    }

    public static Class<?> getCollectionType(Type type) {
        ParameterizedType pt;
        if (type instanceof ParameterizedType && (pt = (ParameterizedType)type).getActualTypeArguments().length == 1) {
            Type argType = pt.getActualTypeArguments()[0];
            if (argType instanceof Class) {
                return (Class)argType;
            }
            if (argType instanceof WildcardType) {
                Type[] upperBounds = ((WildcardType)argType).getUpperBounds();
                if (upperBounds.length > 0 && upperBounds[0] instanceof Class) {
                    return (Class)upperBounds[0];
                }
                Type[] lowerBounds = ((WildcardType)argType).getLowerBounds();
                if (lowerBounds.length > 0 && lowerBounds[0] instanceof Class) {
                    return (Class)lowerBounds[0];
                }
            }
        }
        return null;
    }

    public static Object readObjectProperty(Object object, String propName) throws IllegalAccessException, InvocationTargetException {
        if (propName.indexOf(46) == -1) {
            Method getter = BeanUtils.getGetMethod(object.getClass(), propName);
            return getter == null ? null : getter.invoke(object, new Object[0]);
        }
        StringTokenizer st = new StringTokenizer(propName, ".");
        Object value = object;
        while (value != null && st.hasMoreTokens()) {
            String pathItem = st.nextToken();
            Method getter = BeanUtils.getGetMethod(value.getClass(), pathItem);
            if (getter == null) {
                return null;
            }
            value = getter.invoke(value, new Object[0]);
        }
        return value;
    }

    private static Method getGetMethod(Method[] methods, String getName, String isName, boolean ignoreCase) {
        int i = 0;
        while (i < methods.length) {
            Method method = methods[i];
            if (Modifier.isPublic(method.getModifiers()) && Modifier.isPublic(method.getDeclaringClass().getModifiers()) && method.getParameterTypes().length == 0 && !method.getReturnType().equals(Void.TYPE)) {
                if (!ignoreCase && method.getName().equals(getName)) {
                    return method;
                }
                if (ignoreCase && method.getName().equalsIgnoreCase(getName)) {
                    return method;
                }
                if (method.getReturnType().equals(Boolean.TYPE)) {
                    if (!ignoreCase && method.getName().equals(isName)) {
                        return method;
                    }
                    if (ignoreCase && method.getName().equalsIgnoreCase(isName)) {
                        return method;
                    }
                }
            }
            ++i;
        }
        return null;
    }

    private static Method getSetMethod(Method[] methods, String setName, boolean ignoreCase) {
        int i = 0;
        while (i < methods.length) {
            Method method = methods[i];
            if ((ignoreCase ? method.getName().equalsIgnoreCase(setName) : method.getName().equals(setName)) && Modifier.isPublic(method.getModifiers()) && Modifier.isPublic(method.getDeclaringClass().getModifiers()) && method.getParameterTypes().length == 1) {
                return method;
            }
            ++i;
        }
        return null;
    }

    public static boolean isBooleanType(Type paramClass) {
        return paramClass == Boolean.class || paramClass == Boolean.TYPE;
    }

    public static Object getDefaultPrimitiveValue(Class<?> paramClass) {
        if (paramClass == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        if (paramClass == Short.TYPE) {
            return DEFAULT_SHORT;
        }
        if (paramClass == Integer.TYPE) {
            return DEFAULT_INTEGER;
        }
        if (paramClass == Long.TYPE) {
            return DEFAULT_LONG;
        }
        if (paramClass == Float.TYPE) {
            return DEFAULT_FLOAT;
        }
        if (paramClass == Double.TYPE) {
            return DEFAULT_DOUBLE;
        }
        if (paramClass == Byte.TYPE) {
            return DEFAULT_BYTE;
        }
        if (paramClass == Character.TYPE) {
            return DEFAULT_CHAR;
        }
        throw new IllegalArgumentException("Class " + paramClass.getName() + " is not primitive type");
    }

    public static boolean isNumericType(Class<?> paramClass) {
        return Number.class.isAssignableFrom(paramClass) || paramClass == Short.TYPE || paramClass == Integer.TYPE || paramClass == Long.TYPE || paramClass == Double.TYPE || paramClass == Float.TYPE || paramClass == Byte.TYPE;
    }

    public static Object invokeObjectMethod(Object object, String name, Class<?>[] paramTypes, Object[] args) throws Throwable {
        Method method = object.getClass().getMethod(name, paramTypes);
        method.setAccessible(true);
        try {
            return method.invoke(object, args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    public static Object invokeObjectMethod(Object object, String name) throws Throwable {
        Method method = object.getClass().getMethod(name, new Class[0]);
        method.setAccessible(true);
        try {
            return method.invoke(object, new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    @Nullable
    public static Object invokeObjectDeclaredMethod(@NotNull Object object, @NotNull String methodName, @NotNull Class<?>[] paramTypes, @NotNull Object[] args) throws Throwable {
        Class<?> cls = object.getClass();
        while (cls != null) {
            Method[] methodArray = cls.getDeclaredMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (method.getName().equals(methodName) && Arrays.equals(method.getParameterTypes(), paramTypes)) {
                    method.setAccessible(true);
                    try {
                        return method.invoke(object, args);
                    }
                    catch (InvocationTargetException e) {
                        throw e.getTargetException();
                    }
                }
                ++n2;
            }
            cls = cls.getSuperclass();
        }
        throw new NoSuchMethodException("Cannot find declared method " + methodName + "(" + Arrays.toString(paramTypes) + ")");
    }

    public static Object invokeStaticMethod(Class<?> objectType, String name, Class<?>[] paramTypes, Object[] args) throws Throwable {
        Method method = objectType.getMethod(name, paramTypes);
        method.setAccessible(true);
        try {
            return method.invoke(null, args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    public static <T> Class<? extends T> findAssignableType(Class<?>[] types, Class<T> type) {
        Class<?>[] classArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> childType = classArray[n2];
            if (type.isAssignableFrom(childType)) {
                return childType;
            }
            ++n2;
        }
        return null;
    }

    public static int getInheritanceDistance(Object object, Class<?> clazz) {
        if (clazz.isInstance(object)) {
            int distance = 0;
            Class<?> compared = object.getClass();
            while (compared != clazz) {
                compared = compared.getSuperclass();
                ++distance;
                if (compared == Object.class) break;
            }
            return distance;
        }
        return -1;
    }

    public static <T> T getFieldValue(@NotNull Object object, @NotNull String name) throws Throwable {
        Field field = object.getClass().getDeclaredField(name);
        if (!field.canAccess(object)) {
            field.setAccessible(true);
        }
        return (T)field.get(object);
    }

    @Nullable
    public static Object handleObjectMethod(@NotNull Object proxy, @NotNull Method method, Object[] args) {
        switch (method.getName()) {
            case "toString": {
                return "Proxy";
            }
            case "hashCode": {
                return System.identityHashCode(proxy);
            }
            case "equals": {
                if (proxy == args[0]) {
                    return true;
                }
                return false;
            }
        }
        return null;
    }

    @NotNull
    public static <T> List<T> deepCopy(@NotNull List<T> src) {
        List dst = BeanUtils.tryInstantiateOrDefault(src.getClass(), ArrayList::new);
        for (T element : src) {
            dst.add(BeanUtils.deepCopy(element));
        }
        return dst;
    }

    @NotNull
    public static <K, V> Map<K, V> deepCopy(@NotNull Map<K, V> src) {
        Map dst = BeanUtils.tryInstantiateOrDefault(src.getClass(), LinkedHashMap::new);
        for (Map.Entry<K, V> entry : src.entrySet()) {
            dst.put(entry.getKey(), BeanUtils.deepCopy(entry.getValue()));
        }
        return dst;
    }

    private static <T> T deepCopy(@Nullable T object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Map) {
            return (T)BeanUtils.deepCopy((Map)object);
        }
        if (object instanceof List) {
            return (T)BeanUtils.deepCopy((List)object);
        }
        return object;
    }

    @NotNull
    private static <T> T tryInstantiateOrDefault(@NotNull Class<?> cls, @NotNull Supplier<T> supplier) {
        try {
            return (T)MethodHandles.lookup().findConstructor(cls, MethodType.methodType(Void.TYPE)).invoke();
        }
        catch (Throwable throwable) {
            return supplier.get();
        }
    }
}

