/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.erd.ui.notations;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.erd.ui.notations.ERDNotationDescriptor;

public class ERDNotationRegistry {
    private Log log = Log.getLog(ERDNotationRegistry.class);
    private Map<String, ERDNotationDescriptor> notations = new LinkedHashMap<String, ERDNotationDescriptor>();
    private ERDNotationDescriptor defaultNotation;
    private static ERDNotationRegistry instance;
    private static final String EXTENSION_ID = "org.jkiss.dbeaver.erd.ui.notation.style";

    private ERDNotationRegistry(IExtensionRegistry registry) {
        IConfigurationElement[] cfgElements;
        IConfigurationElement[] iConfigurationElementArray = cfgElements = registry.getConfigurationElementsFor(EXTENSION_ID);
        int n = cfgElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement cfe = iConfigurationElementArray[n2];
            try {
                this.addNotation(new ERDNotationDescriptor(cfe));
            }
            catch (CoreException e) {
                this.log.error((Object)e.getStatus());
            }
            ++n2;
        }
    }

    public static synchronized ERDNotationRegistry getInstance() {
        if (instance == null) {
            instance = new ERDNotationRegistry(Platform.getExtensionRegistry());
        }
        return instance;
    }

    @NotNull
    public List<ERDNotationDescriptor> getERDNotations() {
        return this.notations.values().stream().collect(Collectors.toList());
    }

    private void addNotation(@NotNull ERDNotationDescriptor descriptor) {
        if (this.notations.containsKey(descriptor.getId())) {
            this.log.error((Object)("ER Diagram Notation already defined for id:" + descriptor.getId()));
            return;
        }
        this.notations.put(descriptor.getId(), descriptor);
        if (descriptor.isDefault()) {
            if (this.defaultNotation == null) {
                this.defaultNotation = descriptor;
            } else {
                this.log.error((Object)("The default ERD Notation already defined for id:" + this.defaultNotation.getId()));
            }
        }
    }

    @Nullable
    public ERDNotationDescriptor getNotation(@NotNull String id) {
        if (!this.notations.containsKey(id)) {
            this.log.error((Object)("ERD Notation not defined for key:" + id));
            return null;
        }
        return this.notations.get(id);
    }

    @Nullable
    public ERDNotationDescriptor getDefaultNotation() {
        return this.defaultNotation;
    }

    @Nullable
    public ERDNotationDescriptor getERDNotationByName(String name) {
        for (ERDNotationDescriptor descriptor : this.notations.values()) {
            if (!descriptor.getName().equals(name)) continue;
            return descriptor;
        }
        return null;
    }
}

