/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.erd.ui.notation.crowsfoot;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionEndpointLocator;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.swt.graphics.Color;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.erd.model.ERDAssociation;
import org.jkiss.dbeaver.erd.model.ERDEntity;
import org.jkiss.dbeaver.erd.model.ERDUtils;
import org.jkiss.dbeaver.erd.ui.notation.crowsfoot.CrowsFootPolylineDecoration;
import org.jkiss.dbeaver.erd.ui.notations.ERDAssociationType;
import org.jkiss.dbeaver.erd.ui.notations.ERDNotation;
import org.jkiss.dbeaver.erd.ui.notations.ERDNotationBase;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndex;
import org.jkiss.utils.CommonUtils;

public class CrowsFootDiagramNotation
extends ERDNotationBase
implements ERDNotation {
    private static final Log log = Log.getLog(CrowsFootDiagramNotation.class);

    @Override
    public void applyNotationForArrows(PolylineConnection conn, ERDAssociation association, Color bckColor, Color frgColor) {
        DBSEntityConstraintType constraintType = ((DBSEntityAssociation)association.getObject()).getConstraintType();
        if (constraintType == DBSEntityConstraintType.PRIMARY_KEY) {
            this.createSourceDecorator(conn, bckColor, frgColor, ERDAssociationType.ZERO_OR_ONE, "0..1");
        } else if (constraintType.isAssociation() && association.getSourceEntity() instanceof ERDEntity && association.getTargetEntity() instanceof ERDEntity) {
            try {
                ERDEntity src = (ERDEntity)association.getSourceEntity();
                DBSEntity entity = (DBSEntity)src.getObject();
                VoidProgressMonitor monitor = new VoidProgressMonitor();
                Collection indexes = ((DBSTable)entity).getIndexes((DBRProgressMonitor)monitor);
                if (!CommonUtils.isEmpty((Collection)indexes)) {
                    for (DBSTableIndex index : indexes) {
                        if (!DBUtils.isIdentifierIndex((DBRProgressMonitor)monitor, (DBSTableIndex)index)) continue;
                        List entityIdentifierAttributes = DBUtils.getEntityAttributes((DBRProgressMonitor)monitor, (DBSEntityReferrer)index);
                        List sourceAttributes = association.getSourceAttributes().stream().map(s -> (DBSEntityAttribute)s.getObject()).collect(Collectors.toList());
                        if (sourceAttributes.containsAll(entityIdentifierAttributes)) {
                            this.createSourceDecorator(conn, bckColor, frgColor, ERDAssociationType.ONE_ONLY, "1");
                            continue;
                        }
                        this.createSourceDecorator(conn, bckColor, frgColor, ERDAssociationType.ONE_OR_MANY, "1..n");
                    }
                } else {
                    this.createSourceDecorator(conn, bckColor, frgColor, ERDAssociationType.ONE_OR_MANY, "1..n");
                }
                if (ERDUtils.isOptionalAssociation((ERDAssociation)association)) {
                    this.createTargetDecorator(conn, bckColor, frgColor, ERDAssociationType.ZERO_OR_ONE, "0..1");
                } else {
                    this.createTargetDecorator(conn, bckColor, frgColor, ERDAssociationType.ONE_ONLY, "1");
                }
            }
            catch (DBException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        conn.setLineWidth(1);
        conn.setLineStyle(6);
    }

    private void createSourceDecorator(PolylineConnection conn, Color bckColor, Color frgColor, ERDAssociationType type, String label) {
        CrowsFootPolylineDecoration sourceDecor = new CrowsFootPolylineDecoration(type);
        sourceDecor.setFill(true);
        sourceDecor.setBackgroundColor(bckColor);
        conn.setSourceDecoration((RotatableDecoration)sourceDecor);
        ConnectionEndpointLocator srcEndpointLocator = new ConnectionEndpointLocator((Connection)conn, false);
        srcEndpointLocator.setVDistance(-4);
        srcEndpointLocator.setUDistance(3);
        conn.add((IFigure)this.getLabel(label, frgColor), (Object)srcEndpointLocator);
    }

    private void createTargetDecorator(PolylineConnection conn, Color bckColor, Color frgColor, ERDAssociationType type, String label) {
        CrowsFootPolylineDecoration targetDecor = new CrowsFootPolylineDecoration(type);
        targetDecor.setFill(true);
        targetDecor.setBackgroundColor(bckColor);
        ConnectionEndpointLocator trgEndpointLocator = new ConnectionEndpointLocator((Connection)conn, true);
        trgEndpointLocator.setVDistance(-4);
        trgEndpointLocator.setUDistance(3);
        conn.add((IFigure)this.getLabel(label, frgColor), (Object)trgEndpointLocator);
        conn.setTargetDecoration((RotatableDecoration)targetDecor);
    }

    @Override
    public void applyNotationForEntities(PolylineConnection conn, ERDAssociation association, Color bckColor, Color frgColor) {
    }

    @Override
    public double getIndentation() {
        return 30.0;
    }
}

