/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.handler;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.ui.UIServiceSQL;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetSaveReport;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetSaveSettings;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.dbeaver.ui.controls.resultset.handler.SaveScriptDialog;
import org.jkiss.dbeaver.ui.dialogs.DetailsViewDialog;
import org.jkiss.dbeaver.ui.internal.UINavigatorMessages;
import org.jkiss.utils.CommonUtils;

public class SavePreviewDialog
extends DetailsViewDialog {
    private static final String DIALOG_ID = "DBeaver.RSV.SavePreviewDialog";
    private ResultSetViewer viewer;
    private boolean showCascadeSettings;
    private Object sqlPanel;
    private ResultSetSaveSettings saveSettings;
    private ResultSetSaveReport saveReport;

    public SavePreviewDialog(@NotNull ResultSetViewer viewer, boolean showCascadeSettings, @NotNull ResultSetSaveReport saveReport) {
        super(viewer.getControl().getShell(), "Preview changes", (DBPImage)DBIcon.STATUS_WARNING);
        this.viewer = viewer;
        this.showCascadeSettings = showCascadeSettings;
        this.saveSettings = new ResultSetSaveSettings();
        this.saveReport = saveReport;
    }

    public ResultSetSaveSettings getSaveSettings() {
        return this.saveSettings;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return null;
    }

    protected void createMessageArea(Composite composite) {
        Composite messageGroup = UIUtils.createComposite((Composite)composite, (int)1);
        GridData gd = new GridData(1808);
        gd.minimumWidth = 400;
        messageGroup.setLayoutData((Object)gd);
        String changesReport = "";
        if (this.saveReport.getInserts() > 0) {
            changesReport = SavePreviewDialog.appendReportLine(changesReport, this.saveReport.getInserts(), "rows(s) added");
        }
        if (this.saveReport.getUpdates() > 0) {
            changesReport = SavePreviewDialog.appendReportLine(changesReport, this.saveReport.getUpdates(), "rows(s) changed");
        }
        if (this.saveReport.getDeletes() > 0) {
            changesReport = SavePreviewDialog.appendReportLine(changesReport, this.saveReport.getDeletes(), "rows(s) deleted");
        }
        Composite msgComposite = UIUtils.createComposite((Composite)messageGroup, (int)2);
        Label imgLabel = new Label(msgComposite, 0);
        imgLabel.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.STATUS_WARNING));
        Label msgText = new Label(msgComposite, 0);
        msgText.setText("You are about to save your changes into the database (" + this.viewer.getDataSource().getContainer().getName() + ").\n" + (CommonUtils.isEmpty((String)changesReport) ? "" : "\t" + changesReport + ".") + "\nAre you sure you want to proceed?");
        if (this.showCascadeSettings) {
            boolean useDeleteCascade = this.saveReport.isHasReferences() && this.saveReport.getDeletes() > 0;
            SaveScriptDialog.createDeleteCascadeControls(messageGroup, this.saveSettings, useDeleteCascade, this::populateSQL);
        }
    }

    private static String appendReportLine(String report, int count, String info) {
        if (!report.isEmpty()) {
            report = String.valueOf(report) + ", ";
        }
        return String.valueOf(report) + count + " " + info;
    }

    protected String getDetailsLabel(boolean show) {
        return show ? "SQL >>" : "SQL <<";
    }

    protected void createButtonsForButtonBar(@NotNull Composite parent, int alignment) {
        if (alignment == 16384) {
            this.createDetailsButton(parent);
            ((GridData)this.detailsButton.getLayoutData()).horizontalAlignment = 1;
        } else {
            this.createButton(parent, 0, UINavigatorMessages.dialog_filter_save_button, false);
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, true);
        }
    }

    protected Control createDetailsContents(Composite composite) {
        Composite group = new Composite(composite, 0);
        group.setLayout((Layout)new GridLayout(1, true));
        group.setLayoutData((Object)new GridData(1808));
        Composite previewFrame = new Composite(group, 2048);
        GridData gd = new GridData(1808);
        gd.heightHint = 250;
        previewFrame.setLayoutData((Object)gd);
        previewFrame.setLayout((Layout)new FillLayout());
        UIServiceSQL serviceSQL = (UIServiceSQL)DBWorkbench.getService(UIServiceSQL.class);
        if (serviceSQL != null) {
            try {
                this.sqlPanel = serviceSQL.createSQLPanel((Object)this.viewer.getSite(), (Object)previewFrame, (DBPContextProvider)this.viewer, UINavigatorMessages.editors_entity_dialog_preview_title, true, "");
            }
            catch (Exception e) {
                DBWorkbench.getPlatformUI().showError("Can't create SQL panel", "Error creating SQL panel", (Throwable)e);
            }
        }
        this.populateSQL();
        return previewFrame;
    }

    private void populateSQL() {
        try {
            ArrayList sqlScript = new ArrayList();
            UIUtils.runInProgressService(monitor -> {
                List<DBEPersistAction> script = this.viewer.generateChangesScript(monitor, this.saveSettings);
                if (script != null) {
                    sqlScript.addAll(script);
                }
            });
            String scriptText = "";
            if (!sqlScript.isEmpty()) {
                scriptText = SQLUtils.generateScript((DBPDataSource)this.viewer.getDataSource(), (DBEPersistAction[])sqlScript.toArray(new DBEPersistAction[0]), (boolean)false);
                scriptText = String.valueOf(SQLUtils.generateCommentLine((DBPDataSource)this.viewer.getDataSource(), (String)"Auto-generated SQL script. Actual values for binary/complex data types may differ - what you see is the default string representation of values.")) + scriptText;
                UIServiceSQL serviceSQL = (UIServiceSQL)DBWorkbench.getService(UIServiceSQL.class);
                if (serviceSQL != null) {
                    serviceSQL.setSQLPanelText(this.sqlPanel, scriptText);
                }
            }
        }
        catch (Exception e) {
            DBWorkbench.getPlatformUI().showError("Can't generalte SQL script", "Error generating SQL script from changes", (Throwable)e);
        }
    }
}

