/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.runtime.properties;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBECommandReflector;
import org.jkiss.dbeaver.model.edit.DBEObjectEditor;
import org.jkiss.dbeaver.model.edit.DBEObjectMaker;
import org.jkiss.dbeaver.model.edit.prop.DBECommandProperty;
import org.jkiss.dbeaver.model.edit.prop.DBEPropertyHandler;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.properties.IPropertySourceEditable;
import org.jkiss.dbeaver.runtime.properties.ObjectPropertyDescriptor;
import org.jkiss.dbeaver.runtime.properties.PropertySourceAbstract;
import org.jkiss.utils.CommonUtils;

public class PropertySourceEditable
extends PropertySourceAbstract
implements DBPObject,
IPropertySourceEditable {
    private static final Log log = Log.getLog(PropertySourceEditable.class);
    private DBECommandContext commandContext;
    private PropertyChangeCommand lastCommand = null;
    private final CommandReflector commandReflector = new CommandReflector();

    public PropertySourceEditable(DBECommandContext commandContext, Object sourceObject, Object object) {
        super(sourceObject, object, true);
        this.commandContext = commandContext;
    }

    public PropertySourceEditable(Object sourceObject, Object object) {
        super(sourceObject, object, true);
    }

    @Override
    public boolean isEditable(Object object) {
        if (this.commandContext == null) {
            return true;
        }
        DBEObjectEditor objectEditor = this.getObjectEditor(DBEObjectEditor.class);
        return objectEditor != null && object instanceof DBPObject && objectEditor.canEditObject((DBPObject)object) && DBWorkbench.getPlatform().getWorkspace().hasRealmPermission("metadata-editor");
    }

    private <T> T getObjectEditor(Class<T> managerType) {
        Object editableValue = this.getEditableValue();
        if (editableValue == null) {
            return null;
        }
        return DBWorkbench.getPlatform().getEditorsRegistry().getObjectManager(editableValue.getClass(), managerType);
    }

    public DBECommandContext getCommandContext() {
        return this.commandContext;
    }

    @Override
    public void setPropertyValue(@Nullable DBRProgressMonitor monitor, Object editableValue, ObjectPropertyDescriptor prop, Object newValue) throws IllegalArgumentException {
        DBSObjectCache<DBSObject, DBSObject> cache;
        DBEObjectMaker objectManager;
        if (prop.getValueTransformer() != null) {
            newValue = prop.getValueTransformer().transform(editableValue, newValue);
        }
        Object oldValue = this.getPropertyValue(monitor, editableValue, prop, true);
        if (!this.updatePropertyValue(monitor, editableValue, prop, newValue, false)) {
            return;
        }
        if (this.commandContext != null) {
            if (this.lastCommand == null || this.lastCommand.getObject() != editableValue || this.lastCommand.property != prop || !this.commandContext.isDirty()) {
                DBEObjectEditor objectEditor = this.getObjectEditor(DBEObjectEditor.class);
                if (objectEditor == null) {
                    log.error("Can't obtain object editor for " + this.getEditableValue());
                    return;
                }
                DBEPropertyHandler<DBPObject> propertyHandler = objectEditor.makePropertyHandler((DBPObject)editableValue, prop);
                PropertyChangeCommand curCommand = new PropertyChangeCommand((DBPObject)editableValue, prop, propertyHandler, oldValue, newValue);
                this.commandContext.addCommand(curCommand, this.commandReflector);
                this.lastCommand = curCommand;
            } else {
                this.lastCommand.setNewValue(newValue);
                this.commandContext.updateCommand(this.lastCommand, this.commandReflector);
            }
        }
        if (prop.isNameProperty() && editableValue instanceof DBSObject && (objectManager = this.getObjectEditor(DBEObjectMaker.class)) != null && (cache = objectManager.getObjectsCache((DBSObject)editableValue)) != null && cache.isFullyCached()) {
            List cachedObjects = CommonUtils.copyList(cache.getCachedObjects());
            cache.setCache(cachedObjects);
        }
    }

    private boolean updatePropertyValue(@Nullable DBRProgressMonitor monitor, Object editableValue, ObjectPropertyDescriptor prop, Object value, boolean force) throws IllegalArgumentException {
        block11: {
            try {
                Object oldValue;
                Object[] items;
                if (value != null && value.getClass() == String.class && (items = prop.getPossibleValues(editableValue)) != null) {
                    boolean found = false;
                    if (items.length > 0) {
                        int i = 0;
                        int itemsLength = items.length;
                        while (i < itemsLength) {
                            if (items[i] instanceof DBPNamedObject && value.equals(((DBPNamedObject)items[i]).getName()) || items[i] instanceof Enum && value.equals(((Enum)items[i]).name())) {
                                value = items[i];
                                found = true;
                                break;
                            }
                            ++i;
                        }
                    }
                    if (!found && value.getClass() != prop.getDataType()) {
                        value = null;
                    }
                }
                if (!CommonUtils.equalObjects((Object)(oldValue = this.getPropertyValue(monitor, editableValue, prop, true)), (Object)value)) break block11;
                return false;
            }
            catch (Throwable e) {
                if (e instanceof InvocationTargetException) {
                    e = ((InvocationTargetException)e).getTargetException();
                }
                if (e instanceof IllegalArgumentException) {
                    throw (IllegalArgumentException)e;
                }
                throw new IllegalArgumentException("Can't write property '" + prop.getDisplayName() + "' value", e);
            }
        }
        prop.writeValue(editableValue, value);
        if (editableValue instanceof DBSObject) {
            DBUtils.fireObjectUpdate((DBSObject)editableValue, prop);
        }
        this.addChangedProperties(prop, value);
        return true;
    }

    @Override
    public boolean isPropertyResettable(Object object, ObjectPropertyDescriptor prop) {
        return this.lastCommand != null && this.lastCommand.property == prop && this.lastCommand.getObject() == object;
    }

    @Override
    public void resetPropertyValue(@Nullable DBRProgressMonitor monitor, Object object, ObjectPropertyDescriptor prop) {
        if (this.lastCommand != null && this.lastCommand.property == prop) {
            this.setPropertyValue(monitor, object, prop, this.lastCommand.getOldValue());
        }
        log.warn("Property reset not implemented");
    }

    private class CommandReflector
    implements DBECommandReflector<DBPObject, PropertyChangeCommand> {
        private CommandReflector() {
        }

        @Override
        public void redoCommand(PropertyChangeCommand command) {
            PropertySourceEditable.this.updatePropertyValue(null, command.getObject(), command.property, command.getNewValue(), false);
        }

        @Override
        public void undoCommand(PropertyChangeCommand command) {
            PropertySourceEditable.this.updatePropertyValue(null, command.getObject(), command.property, command.getOldValue(), false);
        }
    }

    private class PropertyChangeCommand
    extends DBECommandProperty<DBPObject> {
        ObjectPropertyDescriptor property;

        public PropertyChangeCommand(DBPObject editableValue, ObjectPropertyDescriptor property, DBEPropertyHandler<DBPObject> propertyHandler, Object oldValue, Object newValue) {
            super(editableValue, propertyHandler, oldValue, newValue);
            this.property = property;
        }

        @Override
        public void updateModel() {
            super.updateModel();
            PropertySourceEditable.this.updatePropertyValue(null, this.getObject(), this.property, this.getNewValue(), true);
        }
    }
}

