/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.runtime.jobs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPExclusiveResource;
import org.jkiss.dbeaver.model.DBPMessageType;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCTransactionManager;
import org.jkiss.dbeaver.model.net.DBWNetworkHandler;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.DBeaverNotifications;
import org.jkiss.dbeaver.runtime.jobs.DataSourceJob;

public class InvalidateJob
extends DataSourceJob {
    private static final Log log = Log.getLog(InvalidateJob.class);
    private static final String TASK_INVALIDATE = "dsInvalidate";
    private long timeSpent;
    private List<ContextInvalidateResult> invalidateResults = new ArrayList<ContextInvalidateResult>();
    private Runnable feedbackHandler;

    public InvalidateJob(DBPDataSource dataSource) {
        super("Invalidate " + dataSource.getContainer().getName(), DBUtils.getDefaultContext(dataSource.getDefaultInstance(), false));
    }

    public List<ContextInvalidateResult> getInvalidateResults() {
        return this.invalidateResults;
    }

    public long getTimeSpent() {
        return this.timeSpent;
    }

    public Runnable getFeedbackHandler() {
        return this.feedbackHandler;
    }

    public void setFeedbackHandler(Runnable feedbackHandler) {
        this.feedbackHandler = feedbackHandler;
    }

    @Override
    protected IStatus run(DBRProgressMonitor monitor) {
        DBPDataSource dataSource = this.getExecutionContext().getDataSource();
        this.invalidateResults = InvalidateJob.invalidateDataSource(monitor, dataSource, false, true, this.feedbackHandler);
        return Status.OK_STATUS;
    }

    /*
     * WARNING - void declaration
     */
    public static List<ContextInvalidateResult> invalidateDataSource(DBRProgressMonitor monitor, DBPDataSource dataSource, boolean disconnectOnFailure, boolean showErrors, Runnable feedback) {
        ArrayList<ContextInvalidateResult> invalidateResults = new ArrayList<ContextInvalidateResult>();
        DBPDataSourceContainer container = dataSource.getContainer();
        monitor.beginTask("Invalidate datasource '" + dataSource.getContainer().getName() + "'", 1);
        monitor.subTask("Obtain exclusive datasource lock");
        Object dsLock = container.getExclusiveLock().acquireTaskLock(TASK_INVALIDATE, true);
        if (dsLock == DBPExclusiveResource.TASK_PROCESED) {
            monitor.done();
            log.debug("Datasource '" + dataSource.getContainer().getName() + "' was already invalidated");
            return invalidateResults;
        }
        log.debug("Invalidate datasource '" + container.getName() + "' (" + container.getId() + ")");
        try {
            monitor.subTask("Invalidate network connection");
            DBWNetworkHandler[] activeHandlers = container.getActiveNetworkHandlers();
            boolean networkOK = true;
            int aliveContextsNumber = 0;
            int goodContextsNumber = 0;
            if (activeHandlers != null && activeHandlers.length > 0) {
                void var13_16;
                DBWNetworkHandler[] dBWNetworkHandlerArray = activeHandlers;
                int n = activeHandlers.length;
                boolean n2 = false;
                while (var13_16 < n) {
                    DBWNetworkHandler nh = dBWNetworkHandlerArray[var13_16];
                    log.debug("\tInvalidate network handler '" + nh.getClass().getSimpleName() + "' for " + container.getId());
                    monitor.subTask("Invalidate handler [" + nh.getClass().getSimpleName() + "]");
                    try {
                        nh.invalidateHandler(monitor, dataSource);
                    }
                    catch (Exception e) {
                        invalidateResults.add(new ContextInvalidateResult(DBCExecutionContext.InvalidateResult.ERROR, e));
                        networkOK = false;
                        break;
                    }
                    ++var13_16;
                }
            }
            int totalContexts = 0;
            monitor.subTask("Invalidate connections of [" + container.getName() + "]");
            for (DBSInstance dBSInstance : dataSource.getAvailableInstances()) {
                DBCExecutionContext[] dBCExecutionContextArray = dBSInstance.getAllContexts();
                int n = dBCExecutionContextArray.length;
                int n2 = 0;
                while (n2 < n) {
                    block29: {
                        DBCExecutionContext context = dBCExecutionContextArray[n2];
                        log.debug("\tInvalidate context '" + context.getContextName() + "' for " + container.getId());
                        ++totalContexts;
                        if (networkOK) {
                            long startTime = System.currentTimeMillis();
                            Object exclusiveLock = dBSInstance.getExclusiveLock().acquireExclusiveLock();
                            try {
                                try {
                                    DBCExecutionContext.InvalidateResult result = context.invalidateContext(monitor, disconnectOnFailure);
                                    if (result != DBCExecutionContext.InvalidateResult.ERROR) {
                                        ++goodContextsNumber;
                                    }
                                    if (result == DBCExecutionContext.InvalidateResult.ALIVE) {
                                        ++aliveContextsNumber;
                                    }
                                    invalidateResults.add(new ContextInvalidateResult(result, null));
                                }
                                catch (Exception e) {
                                    log.debug("\tFailed: " + e.getMessage());
                                    invalidateResults.add(new ContextInvalidateResult(DBCExecutionContext.InvalidateResult.ERROR, e));
                                    System.currentTimeMillis();
                                    dBSInstance.getExclusiveLock().releaseExclusiveLock(exclusiveLock);
                                    break block29;
                                }
                            }
                            catch (Throwable throwable) {
                                System.currentTimeMillis();
                                dBSInstance.getExclusiveLock().releaseExclusiveLock(exclusiveLock);
                                throw throwable;
                            }
                            System.currentTimeMillis();
                            dBSInstance.getExclusiveLock().releaseExclusiveLock(exclusiveLock);
                        }
                    }
                    ++n2;
                }
            }
            if (goodContextsNumber > 0 && goodContextsNumber == aliveContextsNumber) {
                ArrayList<ContextInvalidateResult> arrayList = invalidateResults;
                return arrayList;
            }
            if (goodContextsNumber == 0 && disconnectOnFailure) {
                try {
                    container.disconnect(monitor);
                }
                catch (Exception exception) {
                    log.error("Error closing inaccessible datasource", exception);
                }
                StringBuilder stringBuilder = new StringBuilder();
                for (ContextInvalidateResult result : invalidateResults) {
                    if (result.error == null) continue;
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append("\n");
                    }
                    stringBuilder.append(result.error.getMessage());
                }
                DBWorkbench.getPlatformUI().showError("Forced disconnect", "Datasource '" + container.getName() + "' was disconnected: destination database unreachable.\n" + stringBuilder);
            }
            if (totalContexts > 0) {
                if (goodContextsNumber == 0) {
                    if (showErrors) {
                        DBeaverNotifications.showNotification(dataSource, "reconnect.failure", "Datasource invalidate failed", DBPMessageType.ERROR, feedback);
                    }
                } else {
                    DBeaverNotifications.showNotification(dataSource, "reconnect.success", "Datasource was invalidated\n\nLive connection count: " + goodContextsNumber + "/" + totalContexts, DBPMessageType.INFORMATION);
                }
            }
        }
        finally {
            container.getExclusiveLock().releaseTaskLock(TASK_INVALIDATE, dsLock);
            monitor.done();
        }
        return invalidateResults;
    }

    public static void invalidateTransaction(DBRProgressMonitor monitor, DBPDataSource dataSource, DBCExecutionContext executionContext) {
        if (executionContext != null) {
            monitor.subTask("Invalidate context [" + executionContext.getDataSource().getContainer().getName() + "/" + executionContext.getContextName() + "] transactions");
            InvalidateJob.invalidateTransaction(monitor, executionContext);
        } else {
            monitor.subTask("Invalidate datasource [" + dataSource.getContainer().getName() + "] transactions");
            for (DBSInstance dBSInstance : dataSource.getAvailableInstances()) {
                DBCExecutionContext[] dBCExecutionContextArray = dBSInstance.getAllContexts();
                int n = dBCExecutionContextArray.length;
                int n2 = 0;
                while (n2 < n) {
                    DBCExecutionContext context = dBCExecutionContextArray[n2];
                    InvalidateJob.invalidateTransaction(monitor, context);
                    ++n2;
                }
            }
        }
    }

    public static void invalidateTransaction(DBRProgressMonitor monitor, DBCExecutionContext context) {
        block12: {
            DBCTransactionManager txnManager = DBUtils.getTransactionManager(context);
            if (txnManager != null) {
                try {
                    if (txnManager.isAutoCommit()) break block12;
                    Throwable throwable = null;
                    Object var4_6 = null;
                    try (DBCSession session = context.openSession(monitor, DBCExecutionPurpose.UTIL, "Rollback failed transaction");){
                        session.enableLogging(false);
                        txnManager.rollback(session, null);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (DBCException e) {
                    log.error("Error invalidating aborted transaction", e);
                }
            }
        }
    }

    @Override
    protected void canceling() {
        this.getThread().interrupt();
    }

    public static class ContextInvalidateResult {
        public final DBCExecutionContext.InvalidateResult result;
        public final Exception error;

        ContextInvalidateResult(DBCExecutionContext.InvalidateResult result, Exception error) {
            this.result = result;
            this.error = error;
        }

        public String toString() {
            return this.result.name();
        }
    }
}

