/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.navigator.fs;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPHiddenObject;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.fs.DBFFileSystemManager;
import org.jkiss.dbeaver.model.fs.DBFVirtualFileSystem;
import org.jkiss.dbeaver.model.fs.DBFVirtualFileSystemRoot;
import org.jkiss.dbeaver.model.fs.nio.EFSNIOListener;
import org.jkiss.dbeaver.model.fs.nio.EFSNIOMonitor;
import org.jkiss.dbeaver.model.fs.nio.EFSNIOResource;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.navigator.DBNEvent;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.model.navigator.fs.DBNFileSystem;
import org.jkiss.dbeaver.model.navigator.fs.DBNFileSystemRoot;
import org.jkiss.dbeaver.model.navigator.fs.DBNPathBase;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class DBNFileSystems
extends DBNNode
implements DBPHiddenObject,
EFSNIOListener {
    private static final Log log = Log.getLog(DBNFileSystems.class);
    private DBNFileSystem[] children;

    public DBNFileSystems(DBNProject parentNode) {
        super(parentNode);
        EFSNIOMonitor.addListener(this);
    }

    @Override
    protected void dispose(boolean reflect) {
        super.dispose(reflect);
        EFSNIOMonitor.removeListener(this);
    }

    @Override
    public String getNodeType() {
        return "dbfs";
    }

    @Override
    @Property(id="name", viewable=true, order=1)
    public String getNodeName() {
        return "Remote file systems";
    }

    @Override
    public String getNodeDescription() {
        return "All virtual file systems";
    }

    @Override
    public DBPImage getNodeIcon() {
        return DBIcon.TREE_FILE;
    }

    @Override
    public boolean allowsChildren() {
        return true;
    }

    public DBNFileSystem getFileSystem(@Nullable String type, @NotNull String id) {
        if (this.children == null) {
            return null;
        }
        DBNFileSystem[] dBNFileSystemArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            DBNFileSystem fsNode = dBNFileSystemArray[n2];
            DBFVirtualFileSystem fs = fsNode.getFileSystem();
            if ((type == null || fs.getType().equals(type)) && fs.getId().equals(id)) {
                return fsNode;
            }
            ++n2;
        }
        return null;
    }

    public DBNFileSystemRoot getRootFolder(@NotNull DBRProgressMonitor monitor, @NotNull String id) throws DBException {
        DBNFileSystem[] dBNFileSystemArray = this.getChildren(monitor);
        int n = dBNFileSystemArray.length;
        int n2 = 0;
        while (n2 < n) {
            DBNFileSystem fsNode = dBNFileSystemArray[n2];
            DBNFileSystemRoot rootFolder = fsNode.getChild(monitor, id);
            if (rootFolder != null) {
                return rootFolder;
            }
            ++n2;
        }
        return null;
    }

    public DBNFileSystem[] getChildren(DBRProgressMonitor monitor) throws DBException {
        if (this.children == null) {
            this.children = this.readChildNodes(monitor);
        }
        return this.children;
    }

    protected DBNFileSystem[] readChildNodes(DBRProgressMonitor monitor) throws DBException {
        monitor.beginTask("Read available file systems", 1);
        ArrayList<DBNFileSystem> result = new ArrayList<DBNFileSystem>();
        DBPProject project = this.getOwnerProject();
        if (project == null) {
            return new DBNFileSystem[0];
        }
        DBFFileSystemManager fileSystemManager = project.getFileSystemManager();
        for (DBFVirtualFileSystem fs : fileSystemManager.getVirtualFileSystems()) {
            DBNFileSystem newChild = new DBNFileSystem(this, fs);
            result.add(newChild);
        }
        result.sort(DBUtils.nameComparatorIgnoreCase());
        monitor.done();
        return result.toArray(new DBNFileSystem[0]);
    }

    public DBNPathBase findNodeByPath(@NotNull DBRProgressMonitor monitor, @NotNull String path) throws DBException {
        return this.findNodeByPath(monitor, path, false);
    }

    public DBNPathBase findNodeByPath(@NotNull DBRProgressMonitor monitor, @NotNull String path, boolean shortPath) throws DBException {
        DBNNode curPath = null;
        try {
            uri = new URI(path);
        }
        catch (URISyntaxException e) {
            throw new DBException("Bad path: " + path, e);
        }
        String plainPath = uri.getSchemeSpecificPart();
        String[] stringArray = plainPath.split("/");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (!(name.isEmpty() || curPath == null && name.endsWith(":"))) {
                if (curPath == null) {
                    this.getChildren(monitor);
                    curPath = !shortPath ? this.getFileSystem(uri.getScheme(), name) : this.getRootFolder(monitor, name);
                } else {
                    if (curPath instanceof DBNFileSystem var11_12) {
                        fsNode.getChildren(monitor);
                        curPath = fsNode.getRoot(name);
                    } else {
                        DBNPathBase pathNode = curPath;
                        pathNode.getChildren(monitor);
                        curPath = pathNode.getChild(name);
                    }
                }
                if (curPath == null) {
                    return null;
                }
            }
            ++n2;
        }
        return curPath instanceof DBNPathBase ? (DBNPathBase)curPath : null;
    }

    @Override
    public boolean isManagable() {
        return true;
    }

    @Override
    public DBNNode refreshNode(DBRProgressMonitor monitor, Object source) {
        this.children = null;
        return this;
    }

    public void resetFileSystems() {
        this.children = null;
        this.getModel().fireNodeUpdate(this, this, DBNEvent.NodeChange.REFRESH);
    }

    @Override
    public String getNodeItemPath() {
        return String.valueOf(DBNNode.NodePathType.dbvfs.getPrefix()) + ((DBNProject)this.getParentNode()).getRawNodeItemPath() + "/" + this.getNodeName();
    }

    @Override
    public boolean supportsRename() {
        return false;
    }

    @Override
    public void resourceChanged(EFSNIOResource resource, EFSNIOListener.Action action) {
        if (!CommonUtils.equalObjects((Object)this.getOwnerProject().getEclipseProject(), (Object)resource.getProject())) {
            return;
        }
        if (this.children == null) {
            return;
        }
        DBFVirtualFileSystemRoot dbfRoot = resource.getRoot().getRoot();
        DBNFileSystem[] dBNFileSystemArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            DBNFileSystem fs = dBNFileSystemArray[n2];
            if (CommonUtils.equalObjects((Object)fs.getFileSystem(), (Object)dbfRoot.getFileSystem())) {
                DBNFileSystemRoot rootNode = fs.getRoot(dbfRoot);
                if (rootNode == null) break;
                String[] pathSegments = resource.getFullPath().segments();
                DBNPathBase parentNode = rootNode;
                int i = 2;
                while (i < pathSegments.length - 1) {
                    String itemName = pathSegments[i];
                    DBNPathBase childNode = parentNode.getChild(itemName);
                    if (childNode == null) {
                        log.debug("Cannot find child node '" + itemName + "' in '" + parentNode.getNodeItemPath() + "'");
                        return;
                    }
                    parentNode = childNode;
                    ++i;
                }
                switch (action) {
                    case CREATE: {
                        parentNode.addChildResource(resource.getNioPath());
                        break;
                    }
                    case DELETE: {
                        parentNode.removeChildResource(resource.getNioPath());
                        break;
                    }
                }
                break;
            }
            ++n2;
        }
    }

    @Override
    public boolean isHidden() {
        return true;
    }

    public String toString() {
        return "FileSystems(" + this.getOwnerProject().getName() + ")";
    }
}

