/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.fs;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.fs.DBFFileSystemDescriptor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.IOUtils;

public class DBFUtils {
    private static final Log log = Log.getLog(DBFUtils.class);
    private static volatile Boolean SUPPORT_MULTI_FS = null;

    public static boolean supportsMultiFileSystems(@NotNull DBPProject project) {
        if (SUPPORT_MULTI_FS == null) {
            DBFFileSystemDescriptor[] dBFFileSystemDescriptorArray = DBWorkbench.getPlatform().getFileSystemRegistry().getFileSystemProviders();
            int n = dBFFileSystemDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                DBFFileSystemDescriptor fsProvider = dBFFileSystemDescriptorArray[n2];
                Object[] fsList = fsProvider.getInstance().getAvailableFileSystems(new VoidProgressMonitor(), project);
                if (!ArrayUtils.isEmpty((Object[])fsList)) {
                    SUPPORT_MULTI_FS = true;
                    break;
                }
                ++n2;
            }
            if (SUPPORT_MULTI_FS == null) {
                SUPPORT_MULTI_FS = false;
            }
        }
        return SUPPORT_MULTI_FS;
    }

    @NotNull
    public static Path resolvePathFromString(@NotNull DBRProgressMonitor monitor, @Nullable DBPProject project, @NotNull String pathOrUri) throws DBException {
        if (project != null) {
            return project.getFileSystemManager().getPathFromString(monitor, pathOrUri);
        }
        return Path.of(pathOrUri, new String[0]);
    }

    @NotNull
    public static Path resolvePathFromURI(@NotNull DBRProgressMonitor monitor, @Nullable DBPProject project, @NotNull URI uri) throws DBException {
        if (project != null) {
            return project.getFileSystemManager().getPathFromURI(monitor, uri);
        }
        return Path.of(uri);
    }

    @NotNull
    public static Path resolvePathFromString(@NotNull DBRRunnableContext runnableContext, @Nullable DBPProject project, @NotNull String pathOrUri) throws DBException {
        if (!IOUtils.isLocalFile((String)pathOrUri) && project != null && DBFUtils.supportsMultiFileSystems(project)) {
            try {
                Path[] result = new Path[1];
                runnableContext.run(true, true, monitor -> {
                    try {
                        pathArray[0] = project.getFileSystemManager().getPathFromString(monitor, pathOrUri);
                    }
                    catch (DBException e) {
                        throw new InvocationTargetException(e);
                    }
                });
                return result[0];
            }
            catch (InvocationTargetException e) {
                throw new DBException("Error getting path", e.getTargetException());
            }
            catch (InterruptedException interruptedException) {
                throw new DBException("Canceled");
            }
        }
        if (pathOrUri.startsWith("file:")) {
            try {
                return Path.of(new URI(pathOrUri));
            }
            catch (URISyntaxException e) {
                log.debug(e);
            }
        }
        return Path.of(pathOrUri, new String[0]);
    }
}

