/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.fs;

import java.net.URI;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.fs.DBFFileSystemDescriptor;
import org.jkiss.dbeaver.model.fs.DBFFileSystemProvider;
import org.jkiss.dbeaver.model.fs.DBFRegistry;
import org.jkiss.dbeaver.model.fs.DBFVirtualFileSystem;
import org.jkiss.dbeaver.model.fs.event.DBFEventListener;
import org.jkiss.dbeaver.model.fs.event.DBFEventManager;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.LoggingProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

public class DBFFileSystemManager
implements DBFEventListener {
    private volatile Map<String, DBFVirtualFileSystem> dbfFileSystems;
    @NotNull
    private final DBPProject project;

    public DBFFileSystemManager(@NotNull DBPProject project) {
        this.project = project;
        DBFEventManager.getInstance().addListener(this);
    }

    public synchronized void reloadFileSystems(@NotNull DBRProgressMonitor monitor) {
        this.dbfFileSystems = new LinkedHashMap<String, DBFVirtualFileSystem>();
        DBFRegistry fsRegistry = DBWorkbench.getPlatform().getFileSystemRegistry();
        DBFFileSystemDescriptor[] dBFFileSystemDescriptorArray = fsRegistry.getFileSystemProviders();
        int n = dBFFileSystemDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            DBFFileSystemDescriptor fileSystemProviderDescriptor = dBFFileSystemDescriptorArray[n2];
            DBFFileSystemProvider fsProvider = fileSystemProviderDescriptor.getInstance();
            DBFVirtualFileSystem[] dBFVirtualFileSystemArray = fsProvider.getAvailableFileSystems(monitor, this.project);
            int n3 = dBFVirtualFileSystemArray.length;
            int n4 = 0;
            while (n4 < n3) {
                DBFVirtualFileSystem dbfFileSystem = dBFVirtualFileSystemArray[n4];
                this.dbfFileSystems.put(dbfFileSystem.getId(), dbfFileSystem);
                ++n4;
            }
            ++n2;
        }
    }

    @NotNull
    public Path getPathFromString(DBRProgressMonitor monitor, String pathOrUri) throws DBException {
        if (pathOrUri.contains("://")) {
            return this.getPathFromURI(monitor, URI.create(pathOrUri));
        }
        return Path.of(pathOrUri, new String[0]);
    }

    @NotNull
    public Path getPathFromURI(DBRProgressMonitor monitor, URI uri) throws DBException {
        if (IOUtils.isLocalURI((URI)uri)) {
            return Path.of(uri);
        }
        String fsType = uri.getScheme();
        if (CommonUtils.isEmpty((String)fsType)) {
            throw new DBException("File system type not present in the file uri: " + uri);
        }
        String fsId = uri.getAuthority();
        if (CommonUtils.isEmpty((String)fsId)) {
            throw new DBException("File system id not present in the file uri: " + uri);
        }
        DBFVirtualFileSystem fileSystem = this.getVirtualFileSystems().stream().filter(fs -> fs.getType().equals(fsType) && fs.getId().equals(fsId)).findFirst().orElseThrow(() -> new DBException("Cannot find file system provider for the uri '" + uri + "'"));
        try {
            return fileSystem.getPathByURI(monitor, uri);
        }
        catch (Throwable e) {
            throw new DBException("Failed to get path from uri '" + uri + "': " + e.getMessage(), e);
        }
    }

    @NotNull
    public synchronized Collection<DBFVirtualFileSystem> getVirtualFileSystems() {
        if (this.dbfFileSystems == null) {
            this.reloadFileSystems(new LoggingProgressMonitor());
        }
        return this.dbfFileSystems.values();
    }

    @Override
    public void handleFSEvent() {
        this.reloadFileSystems(new LoggingProgressMonitor());
    }

    public void close() {
        DBFEventManager.getInstance().removeListener(this);
    }
}

