/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.access;

import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.access.DBAPasswordChangeInfo;
import org.jkiss.dbeaver.model.access.DBAUserPasswordManager;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class DBAuthUtils {
    public static boolean promptAndChangePasswordForCurrentUser(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer dataSourceContainer, @NotNull DBAUserPasswordManager passwordChangeManager) {
        DBAPasswordChangeInfo userPassword;
        if (DBWorkbench.getPlatform().getApplication().isHeadlessMode()) {
            return false;
        }
        DBPConnectionConfiguration connectionInfo = dataSourceContainer.getConnectionConfiguration();
        String oldPassword = connectionInfo.getUserPassword();
        DBPConnectionConfiguration actualConnectionConfiguration = dataSourceContainer.getActualConnectionConfiguration();
        String userName = actualConnectionConfiguration.getUserName();
        if (CommonUtils.isEmpty((String)userName)) {
            userName = connectionInfo.getUserName();
        }
        if (CommonUtils.isEmpty((String)oldPassword)) {
            oldPassword = actualConnectionConfiguration.getUserPassword();
        }
        if ((userPassword = DBWorkbench.getPlatformUI().promptUserPasswordChange(ModelMessages.dialog_user_password_change_label, userName, oldPassword, false, false)) != null) {
            String newPassword = userPassword.getNewPassword();
            try {
                passwordChangeManager.changeUserPassword(monitor, userName, newPassword, oldPassword);
                if (DBWorkbench.getPlatformUI().confirmAction(ModelMessages.dialog_user_password_change_question_label, ModelMessages.dialog_user_password_change_question_message)) {
                    actualConnectionConfiguration.setUserPassword(newPassword);
                    connectionInfo.setUserPassword(newPassword);
                    dataSourceContainer.persistConfiguration();
                    return true;
                }
            }
            catch (DBException e) {
                DBWorkbench.getPlatformUI().showError(ModelMessages.dialog_user_password_change_label, String.valueOf(ModelMessages.dialog_user_password_change_error_message) + userName, e);
            }
        }
        return false;
    }
}

