/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.gis.panel;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Composite;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.gis.DBGeometry;
import org.jkiss.dbeaver.model.gis.GisTransformUtils;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetPresentation;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetSelection;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetModel;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.dbeaver.ui.data.IAttributeController;
import org.jkiss.dbeaver.ui.data.IDataController;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.data.editors.BaseValueEditor;
import org.jkiss.dbeaver.ui.gis.GeometryDataUtils;
import org.jkiss.dbeaver.ui.gis.IGeometryViewer;
import org.jkiss.dbeaver.ui.gis.panel.GISLeafletViewer;
import org.jkiss.utils.ArrayUtils;

public class GISBrowserViewer
extends BaseValueEditor<Browser>
implements IGeometryViewer {
    private static final Log log = Log.getLog(GISBrowserViewer.class);
    private GISLeafletViewer leafletViewer;

    public GISBrowserViewer(IValueController controller) {
        super(controller);
    }

    @Nullable
    protected Browser createControl(Composite editPlaceholder) {
        IResultSetPresentation presentation = this.valueController.getDataController() instanceof IResultSetController ? ((IResultSetController)this.valueController.getDataController()).getActivePresentation() : null;
        this.leafletViewer = new GISLeafletViewer(editPlaceholder, new DBDAttributeBinding[]{((IAttributeController)this.valueController).getBinding()}, GisTransformUtils.getSpatialDataProvider((DBPDataSource)this.valueController.getExecutionContext().getDataSource()), presentation);
        return this.leafletViewer.getBrowser();
    }

    public void primeEditorValue(@Nullable Object value) throws DBException {
        if (this.leafletViewer == null) {
            return;
        }
        ArrayList<DBGeometry> geometries = new ArrayList<DBGeometry>();
        IDataController dataController = this.valueController.getDataController();
        if (dataController instanceof IResultSetController) {
            IResultSetSelection selection;
            Object[] selectedValues;
            IResultSetController resultSetController = (IResultSetController)dataController;
            DBSTypedObject valueType = this.valueController.getValueType();
            List<GeometryDataUtils.GeomAttrs> geomAttrs = null;
            if (valueType instanceof DBSAttributeBase) {
                geomAttrs = GeometryDataUtils.extractGeometryAttributes(resultSetController);
            }
            if (ArrayUtils.isEmpty((Object[])(selectedValues = (selection = resultSetController.getSelection()).toArray()))) {
                selectedValues = new Object[]{value};
            }
            ResultSetModel model = resultSetController.getModel();
            List leaves = model.getVisibleLeafAttributes();
            Object[] objectArray = selectedValues;
            int n = selectedValues.length;
            int n2 = 0;
            while (n2 < n) {
                DBGeometry geometry;
                ResultSetRow row;
                DBDAttributeBinding attr;
                Object cell = objectArray[n2];
                if (cell instanceof DBGeometry) {
                    attr = resultSetController.getActivePresentation().getCurrentAttribute();
                    row = resultSetController.getCurrentRow();
                    geometry = (DBGeometry)cell;
                } else {
                    attr = selection.getElementAttribute(cell);
                    row = selection.getElementRow(cell);
                    Object cellValue = model.getCellValue(attr, row);
                    geometry = GisTransformUtils.getGeometryValueFromObject((DBSDataContainer)this.valueController.getDataController().getDataContainer(), (DBDValueHandler)this.valueController.getValueHandler(), (DBSTypedObject)this.valueController.getValueType(), (Object)cellValue);
                }
                if (geometry != null) {
                    int leaf;
                    geometries.add(geometry);
                    if (valueType instanceof DBSAttributeBase) {
                        int i = 0;
                        while (i < geomAttrs.size()) {
                            GeometryDataUtils.GeomAttrs ga = geomAttrs.get(i);
                            if (ga.geomAttr.matches((DBSAttributeBase)attr, false)) {
                                GeometryDataUtils.setGeometryProperties(resultSetController, ga, geometry, GeometryDataUtils.makeGeometryColor(i), row);
                                break;
                            }
                            ++i;
                        }
                    }
                    if (row != null && attr != null && (leaf = leaves.indexOf(attr)) >= 0) {
                        geometry.putProperties(Map.of("location", String.valueOf(leaf) + ":" + row.getRowNumber()));
                    }
                }
                ++n2;
            }
        }
        this.leafletViewer.setGeometryData(geometries.toArray(new DBGeometry[0]));
    }

    public void dispose() {
        if (this.leafletViewer.getBrowser() != null) {
            super.dispose();
        } else {
            new Job("Disposing browser"){

                protected IStatus run(IProgressMonitor monitor) {
                    while (GISBrowserViewer.this.leafletViewer.isBrowserCreating()) {
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException interruptedException) {
                            break;
                        }
                    }
                    UIUtils.syncExec(() -> GISBrowserViewer.access$1(GISBrowserViewer.this));
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }

    public boolean isReadOnly() {
        return true;
    }

    @Nullable
    public Object extractEditorValue() throws DBCException {
        if (this.leafletViewer == null) {
            return null;
        }
        return this.leafletViewer.getCurrentValue();
    }

    static /* synthetic */ void access$1(GISBrowserViewer gISBrowserViewer) {
        super.dispose();
    }
}

