/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.oracle.model.OracleObjectPersistAction;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchedulerJob;
import org.jkiss.dbeaver.ext.oracle.model.OracleUtils;
import org.jkiss.dbeaver.ext.oracle.model.source.OracleSourceObject;
import org.jkiss.dbeaver.ext.oracle.model.source.OracleStatefulObject;
import org.jkiss.dbeaver.ext.oracle.ui.actions.OracleTaskHandler;
import org.jkiss.dbeaver.model.DBPEvent;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatementType;
import org.jkiss.dbeaver.model.exec.compile.DBCCompileError;
import org.jkiss.dbeaver.model.exec.compile.DBCCompileLog;
import org.jkiss.dbeaver.model.exec.compile.DBCCompileLogBase;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectState;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.entity.EntityEditor;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class JobRunHandler
extends OracleTaskHandler {
    private static final Log log = Log.getLog(JobRunHandler.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart activePart = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        List<OracleSchedulerJob> objects = this.getSelectedJobs(event);
        if (!objects.isEmpty()) {
            EntityEditor entityEditor;
            if (activePart instanceof EntityEditor && (entityEditor = (EntityEditor)activePart).isDirty()) {
                NullProgressMonitor monitor = new NullProgressMonitor();
                entityEditor.doSave((IProgressMonitor)monitor);
                if (monitor.isCanceled()) {
                    return null;
                }
            }
            Shell activeShell = HandlerUtil.getActiveShell((ExecutionEvent)event);
            if (objects.size() == 1) {
                OracleSchedulerJob job = objects.get(0);
                DBCCompileLogBase compileLog = new DBCCompileLogBase();
                compileLog.clearLog();
                Throwable error = null;
                try {
                    UIUtils.runInProgressService(arg_0 -> JobRunHandler.lambda$0((DBCCompileLog)compileLog, job, arg_0));
                    if (compileLog.getError() != null) {
                        error = compileLog.getError();
                    }
                }
                catch (InvocationTargetException e) {
                    error = e.getTargetException();
                }
                catch (InterruptedException interruptedException) {
                    return null;
                }
                if (error != null) {
                    DBWorkbench.getPlatformUI().showError("Unexpected run schedule error", null, error);
                } else if (!CommonUtils.isEmpty((Collection)compileLog.getErrorStack())) {
                    int line = -1;
                    StringBuilder fullMessage = new StringBuilder();
                    for (DBCCompileError oce : compileLog.getErrorStack()) {
                        fullMessage.append(oce.toString()).append(GeneralUtils.getDefaultLineSeparator());
                        if (line >= 0) continue;
                        line = oce.getLine();
                        oce.getPosition();
                    }
                    String errorTitle = String.valueOf(job.getName()) + " run schedule failed";
                    DBWorkbench.getPlatformUI().showError(errorTitle, fullMessage.toString());
                } else {
                    String message = String.valueOf(job.getName()) + " successfully scheduled to run";
                    UIUtils.showMessageBox((Shell)activeShell, (String)"Done", (String)message, (int)2);
                }
            }
        }
        return null;
    }

    private List<OracleSchedulerJob> getSelectedJobs(ExecutionEvent event) {
        IWorkbenchPart activePart;
        OracleSchedulerJob sourceJob;
        ArrayList<OracleSchedulerJob> objects = new ArrayList<OracleSchedulerJob>();
        ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (currentSelection instanceof IStructuredSelection && !currentSelection.isEmpty()) {
            for (Object element : (IStructuredSelection)currentSelection) {
                OracleSchedulerJob sourceJob2 = (OracleSchedulerJob)RuntimeUtils.getObjectAdapter(element, OracleSchedulerJob.class);
                if (sourceJob2 == null) continue;
                objects.add(sourceJob2);
            }
        }
        if (objects.isEmpty() && (sourceJob = (OracleSchedulerJob)RuntimeUtils.getObjectAdapter((Object)(activePart = HandlerUtil.getActivePart((ExecutionEvent)event)), OracleSchedulerJob.class)) != null) {
            objects.add(sourceJob);
        }
        return objects;
    }

    public void updateElement(UIElement element, Map parameters) {
        List<OracleSourceObject> objects = this.getOracleSourceObjects(element);
        if (!objects.isEmpty()) {
            if (objects.size() > 1) {
                element.setText("Run " + objects.size() + " jobs");
            } else {
                OracleSourceObject sourceObject = objects.get(0);
                String objectType = OracleUtils.formatWord((String)sourceObject.getSourceType().name());
                element.setText("Run " + objectType);
            }
        }
    }

    public static boolean runJob(DBRProgressMonitor monitor, DBCCompileLog compileLog, OracleSchedulerJob job) throws DBCException {
        Object[] compileActions = job.getRunActions();
        if (ArrayUtils.isEmpty((Object[])compileActions)) {
            return true;
        }
        Throwable throwable = null;
        Object var5_6 = null;
        try (JDBCSession session = (JDBCSession)DBUtils.openUtilSession((DBRProgressMonitor)monitor, (DBSObject)job, (String)("Run '" + job.getName() + "'"));){
            boolean success = true;
            Object[] objectArray = compileActions;
            int n = compileActions.length;
            int n2 = 0;
            while (n2 < n) {
                Object action = objectArray[n2];
                String script = action.getScript();
                compileLog.trace(script);
                if (monitor.isCanceled()) break;
                try {
                    Throwable throwable2 = null;
                    Object var14_18 = null;
                    try (JDBCStatement dbStat = session.prepareStatement(DBCStatementType.SCRIPT, script, false, false, false);){
                        action.beforeExecute((DBCSession)session);
                        dbStat.executeStatement();
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                    action.afterExecute((DBCSession)session, null);
                }
                catch (DBCException e) {
                    action.afterExecute((DBCSession)session, (Throwable)e);
                    throw e;
                }
                if (action instanceof OracleObjectPersistAction && !JobRunHandler.logObjectErrors(session, compileLog, (OracleStatefulObject)job, ((OracleObjectPersistAction)action).getObjectType())) {
                    success = false;
                }
                ++n2;
            }
            DBSObjectState oldState = job.getObjectState();
            job.refreshObjectState(monitor);
            if (job.getObjectState() != oldState) {
                job.getDataSource().getContainer().fireEvent(new DBPEvent(DBPEvent.Action.OBJECT_UPDATE, (DBSObject)job));
            }
            return success;
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private static /* synthetic */ void lambda$0(DBCCompileLog dBCCompileLog, OracleSchedulerJob oracleSchedulerJob, DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            JobRunHandler.runJob(monitor, dBCCompileLog, oracleSchedulerJob);
        }
        catch (DBCException e) {
            throw new InvocationTargetException(e);
        }
    }
}

