/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.dialogs;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.navigator.DBNLocalFolder;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNNodeWithResource;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.MessageBoxBuilder;
import org.jkiss.dbeaver.ui.dialogs.Reply;
import org.jkiss.dbeaver.ui.internal.UINavigatorMessages;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorObjectsDeleter;
import org.jkiss.utils.CommonUtils;

public final class NavigatorNodesDeletionConfirmations {
    public static final Reply SHOW_SCRIPT = new Reply(UINavigatorMessages.actions_navigator_view_script_button);

    public static Reply confirm(@NotNull Shell shell, @NotNull Collection<?> selectedObjects, @Nullable NavigatorObjectsDeleter deleter) {
        if (selectedObjects.size() > 1) {
            return NavigatorNodesDeletionConfirmations.confirm(shell, UINavigatorMessages.confirm_deleting_multiple_objects_title, NLS.bind((String)UINavigatorMessages.confirm_deleting_multiple_objects_message, (Object)selectedObjects.size()), selectedObjects, deleter);
        }
        DBNNode node = (DBNNode)selectedObjects.iterator().next();
        String title = NLS.bind((String)(node instanceof DBNLocalFolder ? UINavigatorMessages.confirm_local_folder_delete_title : UINavigatorMessages.confirm_entity_delete_title), (Object)node.getNodeType(), (Object)node.getNodeName());
        String message = NLS.bind((String)(node instanceof DBNLocalFolder ? UINavigatorMessages.confirm_local_folder_delete_message : UINavigatorMessages.confirm_entity_delete_message), (Object)node.getNodeType(), (Object)node.getNodeName());
        return NavigatorNodesDeletionConfirmations.confirm(shell, title, message, selectedObjects, deleter);
    }

    public static Reply confirm(@NotNull Shell shell, @NotNull String title, @NotNull String message, @NotNull Collection<?> selectedObjects, @Nullable NavigatorObjectsDeleter deleter) {
        ArrayList<Reply> replies = new ArrayList<Reply>(3);
        replies.add(Reply.YES);
        if (deleter != null && deleter.supportsShowViewScript()) {
            replies.add(SHOW_SCRIPT);
        }
        replies.add(Reply.CANCEL);
        Reply[] reply = new Reply[1];
        MessageBoxBuilder messageBoxBuilder = MessageBoxBuilder.builder((Shell)shell).setTitle(title).setMessage(message).setPrimaryImage((DBPImage)DBIcon.STATUS_WARNING).setReplies(replies).setDefaultReply(Reply.CANCEL).setCustomArea(parent -> NavigatorNodesDeletionConfirmations.createCustomArea(parent, selectedObjects, deleter));
        UIUtils.syncExec(() -> {
            Reply reply = messageBoxBuilder.showMessageBox();
        });
        return reply[0];
    }

    private static void createCustomArea(@NotNull Composite parent, @NotNull Collection<?> selectedObjects, @Nullable NavigatorObjectsDeleter deleter) {
        if (selectedObjects.size() > 1) {
            NavigatorNodesDeletionConfirmations.createObjectsTable(parent, selectedObjects);
        }
        if (deleter != null) {
            NavigatorNodesDeletionConfirmations.createDeleteContents(parent, deleter);
            for (NavigatorObjectsDeleter.Option option : deleter.getSupportedOptions()) {
                NavigatorNodesDeletionConfirmations.createCheckbox(parent, option, deleter);
            }
        }
    }

    private static void createObjectsTable(@NotNull Composite parent, @NotNull Collection<?> selectedObjects) {
        Composite placeholder = UIUtils.createComposite((Composite)parent, (int)1);
        placeholder.setLayoutData((Object)new GridData(1808));
        Group tableGroup = UIUtils.createControlGroup((Composite)placeholder, (String)UINavigatorMessages.confirm_deleting_multiple_objects_table_group_name, (int)1, (int)1808, (int)0);
        tableGroup.setLayoutData((Object)new GridData(1808));
        Table objectsTable = new Table((Composite)tableGroup, 67584);
        objectsTable.setHeaderVisible(true);
        objectsTable.setLinesVisible(true);
        GridData gd = new GridData(1808);
        int fontHeight = UIUtils.getFontHeight((Control)objectsTable);
        selectedObjects.size();
        gd.widthHint = fontHeight * 7;
        objectsTable.setLayoutData((Object)gd);
        UIUtils.createTableColumn((Table)objectsTable, (int)16384, (String)UINavigatorMessages.confirm_deleting_multiple_objects_column_name);
        UIUtils.createTableColumn((Table)objectsTable, (int)16384, (String)"Type");
        UIUtils.createTableColumn((Table)objectsTable, (int)16384, (String)UINavigatorMessages.confirm_deleting_multiple_objects_column_description);
        for (Object obj : selectedObjects) {
            if (!(obj instanceof DBNNode)) continue;
            DBNNode node = (DBNNode)obj;
            TableItem item = new TableItem(objectsTable, 0);
            item.setImage(DBeaverIcons.getImage((DBPImage)node.getNodeIcon()));
            if (node instanceof DBNNodeWithResource) {
                item.setText(0, node.getName());
                IResource resource = ((DBNNodeWithResource)node).getResource();
                IPath resLocation = resource.getLocation();
                item.setText(1, "File");
                item.setText(2, resLocation == null ? "" : resLocation.toString());
                continue;
            }
            item.setText(0, node.getNodeFullName());
            item.setText(1, node.getNodeType());
            item.setText(2, CommonUtils.toString((Object)node.getNodeDescription()));
        }
        UIUtils.asyncExec(() -> UIUtils.packColumns((Table)objectsTable, (boolean)true));
    }

    private static void createDeleteContents(@NotNull Composite parent, final @NotNull NavigatorObjectsDeleter deleter) {
        if (!deleter.supportsDeleteContents()) {
            return;
        }
        IProject project = deleter.getProjectToDelete();
        if (project == null || DBWorkbench.isDistributed()) {
            return;
        }
        Composite ph = UIUtils.createPlaceholder((Composite)parent, (int)2, (int)5);
        final Button deleteContentsCheck = UIUtils.createCheckbox((Composite)ph, (String)UINavigatorMessages.confirm_deleting_delete_contents_checkbox, (String)UINavigatorMessages.confirm_deleting_delete_contents_checkbox_tooltip, (boolean)false, (int)2);
        deleteContentsCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                deleter.setDeleteContents(deleteContentsCheck.getSelection());
            }
        });
        UIUtils.createLabelText((Composite)ph, (String)UINavigatorMessages.confirm_deleting_project_location_label, (String)project.getLocation().toFile().getAbsolutePath(), (int)8);
    }

    private static void createCheckbox(@NotNull Composite checkboxesComposite, final @NotNull NavigatorObjectsDeleter.Option option, final @NotNull NavigatorObjectsDeleter deleter) {
        Composite placeholder = UIUtils.createPlaceholder((Composite)checkboxesComposite, (int)1, (int)5);
        final Button checkbox = UIUtils.createCheckbox((Composite)placeholder, (String)option.getLabel(), (String)option.getTip(), (boolean)false, (int)0);
        checkbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (checkbox.getSelection()) {
                    deleter.enableOption(option);
                } else {
                    deleter.disableOption(option);
                }
            }
        });
    }

    private NavigatorNodesDeletionConfirmations() {
    }
}

