/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.datavirtuality;

import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.datavirtuality.model.DataVirtualityDataSource;
import org.jkiss.dbeaver.ext.datavirtuality.model.DataVirtualityMetaModel;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSourceProvider;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class DataVirtualityDataSourceProvider
extends JDBCDataSourceProvider {
    private static final Log log = Log.getLog(DataVirtualityDataSourceProvider.class);

    public long getFeatures() {
        return 2L;
    }

    public String getConnectionURL(DBPDriver driver, DBPConnectionConfiguration connectionInfo) {
        StringBuilder url = new StringBuilder();
        url.append("jdbc:datavirtuality:");
        url.append(connectionInfo.getDatabaseName());
        url.append("@");
        if (!CommonUtils.isEmpty((String)connectionInfo.getProviderProperty("@dbeaver-ssl@"))) {
            url.append(connectionInfo.getProviderProperty("@dbeaver-ssl@"));
        } else {
            url.append("mm");
        }
        url.append("://");
        url.append(connectionInfo.getHostName());
        if (!CommonUtils.isEmpty((String)connectionInfo.getHostPort())) {
            url.append(":").append(connectionInfo.getHostPort());
        }
        log.debug((Object)("getConnectionURL" + url.toString()));
        return url.toString();
    }

    private static boolean addParameter(StringBuilder url, String name, String value, boolean hasParam) {
        if (!CommonUtils.isEmpty((String)value)) {
            if (hasParam) {
                url.append("&");
            }
            url.append(name).append("=").append(value);
            return true;
        }
        return hasParam;
    }

    @NotNull
    public DBPDataSource openDataSource(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container) throws DBException {
        return new DataVirtualityDataSource(monitor, container, new DataVirtualityMetaModel());
    }
}

