/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.task;

import java.util.Date;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.task.DBTTaskRun;
import org.jkiss.utils.CommonUtils;

public class TaskRunImpl
implements DBTTaskRun {
    private final String id;
    private final Date startTime;
    private final String startUser;
    private final String startedBy;
    private long duration = -1L;
    private String errorMessage;
    private String errorStackTrace;
    private String extraMessage;

    protected TaskRunImpl(@NotNull String id, @NotNull Date startTime, @NotNull String startUser, @NotNull String startedBy, @Nullable String errorMessage, @Nullable String errorStackTrace) {
        this.id = id;
        this.startTime = startTime;
        this.startUser = startUser;
        this.startedBy = startedBy;
        this.errorMessage = errorMessage;
        this.errorStackTrace = errorStackTrace;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public Date getStartTime() {
        return this.startTime;
    }

    @NotNull
    public String getStartUser() {
        return this.startUser;
    }

    @NotNull
    public String getStartedBy() {
        return this.startedBy;
    }

    public long getRunDuration() {
        return this.duration;
    }

    public void setRunDuration(long duration) {
        this.duration = duration;
    }

    public boolean isRunSuccess() {
        return this.errorMessage == null;
    }

    public boolean isFinished() {
        return this.duration >= 0L;
    }

    @Nullable
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    @Nullable
    public String getErrorStackTrace() {
        return this.errorStackTrace;
    }

    public void setErrorStackTrace(String errorStackTrace) {
        this.errorStackTrace = errorStackTrace;
    }

    @Nullable
    public String getExtraMessage() {
        return this.extraMessage;
    }

    public void setExtraMessage(String message) {
        this.extraMessage = message;
    }

    public String toString() {
        return String.valueOf(this.id) + "; " + this.startUser + "; " + this.startedBy + "; " + (this.isRunSuccess() ? "Success" : CommonUtils.notEmpty((String)this.errorMessage));
    }

    public boolean equals(Object obj) {
        return obj instanceof TaskRunImpl && this.id.equals(((TaskRunImpl)obj).id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

